--
-- PostgreSQL database dump
--

-- Dumped from database version 14.2
-- Dumped by pg_dump version 14.2

-- Started on 2022-08-25 15:07:57

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- TOC entry 11 (class 2615 OID 2456927)
-- Name: a_aeropuerto_superficie; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA a_aeropuerto_superficie;


ALTER SCHEMA a_aeropuerto_superficie OWNER TO postgres;

--
-- TOC entry 31 (class 2615 OID 2456928)
-- Name: catalogo_objetos; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA catalogo_objetos;


ALTER SCHEMA catalogo_objetos OWNER TO postgres;

--
-- TOC entry 16 (class 2615 OID 2456929)
-- Name: d_linderos_propiedad; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA d_linderos_propiedad;


ALTER SCHEMA d_linderos_propiedad OWNER TO postgres;

--
-- TOC entry 32 (class 2615 OID 2456930)
-- Name: gs_asociado_poblados; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA gs_asociado_poblados;


ALTER SCHEMA gs_asociado_poblados OWNER TO postgres;

--
-- TOC entry 22 (class 2615 OID 2456931)
-- Name: gs_construcciones; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA gs_construcciones;


ALTER SCHEMA gs_construcciones OWNER TO postgres;

--
-- TOC entry 28 (class 2615 OID 2456932)
-- Name: gs_recreacion; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA gs_recreacion;


ALTER SCHEMA gs_recreacion OWNER TO postgres;

--
-- TOC entry 20 (class 2615 OID 2456933)
-- Name: ho_aguas_interiores; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA ho_aguas_interiores;


ALTER SCHEMA ho_aguas_interiores OWNER TO postgres;

--
-- TOC entry 12 (class 2615 OID 2456934)
-- Name: ho_puertos_muelles; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA ho_puertos_muelles;


ALTER SCHEMA ho_puertos_muelles OWNER TO postgres;

--
-- TOC entry 18 (class 2615 OID 2456935)
-- Name: ho_regulacion_zonas_restringidas; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA ho_regulacion_zonas_restringidas;


ALTER SCHEMA ho_regulacion_zonas_restringidas OWNER TO postgres;

--
-- TOC entry 15 (class 2615 OID 2456936)
-- Name: ho_zonas_costeras; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA ho_zonas_costeras;


ALTER SCHEMA ho_zonas_costeras OWNER TO postgres;

--
-- TOC entry 26 (class 2615 OID 2456937)
-- Name: ii_agropecuaria; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA ii_agropecuaria;


ALTER SCHEMA ii_agropecuaria OWNER TO postgres;

--
-- TOC entry 30 (class 2615 OID 2456938)
-- Name: it_asociado_transportacion; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA it_asociado_transportacion;


ALTER SCHEMA it_asociado_transportacion OWNER TO postgres;

--
-- TOC entry 14 (class 2615 OID 2456939)
-- Name: it_cruces_enlaces; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA it_cruces_enlaces;


ALTER SCHEMA it_cruces_enlaces OWNER TO postgres;

--
-- TOC entry 13 (class 2615 OID 2456940)
-- Name: it_ferrocarriles; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA it_ferrocarriles;


ALTER SCHEMA it_ferrocarriles OWNER TO postgres;

--
-- TOC entry 19 (class 2615 OID 2456941)
-- Name: it_transporte_terrestre; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA it_transporte_terrestre;


ALTER SCHEMA it_transporte_terrestre OWNER TO postgres;

--
-- TOC entry 29 (class 2615 OID 2456942)
-- Name: proyecto_qgis3; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA proyecto_qgis3;


ALTER SCHEMA proyecto_qgis3 OWNER TO postgres;

--
-- TOC entry 27 (class 2615 OID 2456943)
-- Name: visualizacion; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA visualizacion;


ALTER SCHEMA visualizacion OWNER TO postgres;

--
-- TOC entry 6 (class 3079 OID 17619)
-- Name: address_standardizer; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS address_standardizer WITH SCHEMA public;


--
-- TOC entry 7444 (class 0 OID 0)
-- Dependencies: 6
-- Name: EXTENSION address_standardizer; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION address_standardizer IS 'Used to parse an address into constituent elements. Generally used to support geocoding address normalization step.';


--
-- TOC entry 5 (class 3079 OID 17608)
-- Name: fuzzystrmatch; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS fuzzystrmatch WITH SCHEMA public;


--
-- TOC entry 7445 (class 0 OID 0)
-- Dependencies: 5
-- Name: EXTENSION fuzzystrmatch; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION fuzzystrmatch IS 'determine similarities and distance between strings';


--
-- TOC entry 2 (class 3079 OID 16386)
-- Name: postgis; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS postgis WITH SCHEMA public;


--
-- TOC entry 7446 (class 0 OID 0)
-- Dependencies: 2
-- Name: EXTENSION postgis; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION postgis IS 'PostGIS geometry and geography spatial types and functions';


--
-- TOC entry 8 (class 3079 OID 18036)
-- Name: postgis_raster; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS postgis_raster WITH SCHEMA public;


--
-- TOC entry 7447 (class 0 OID 0)
-- Dependencies: 8
-- Name: EXTENSION postgis_raster; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION postgis_raster IS 'PostGIS raster types and functions';


--
-- TOC entry 4 (class 3079 OID 17581)
-- Name: postgis_sfcgal; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS postgis_sfcgal WITH SCHEMA public;


--
-- TOC entry 7448 (class 0 OID 0)
-- Dependencies: 4
-- Name: EXTENSION postgis_sfcgal; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION postgis_sfcgal IS 'PostGIS SFCGAL functions';

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- TOC entry 309 (class 1259 OID 2456944)
-- Name: aeropuerto_a; Type: TABLE; Schema: a_aeropuerto_superficie; Owner: postgres
--

CREATE TABLE a_aeropuerto_superficie.aeropuerto_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'GB005'::character varying NOT NULL,
    nam character varying(80),
    acc integer NOT NULL,
    iko character varying(4),
    fuc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32718)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'GB005'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE a_aeropuerto_superficie.aeropuerto_a OWNER TO postgres;

--
-- TOC entry 7451 (class 0 OID 0)
-- Dependencies: 309
-- Name: TABLE aeropuerto_a; Type: COMMENT; Schema: a_aeropuerto_superficie; Owner: postgres
--

COMMENT ON TABLE a_aeropuerto_superficie.aeropuerto_a IS 'Zona provista de un conjunto de pistas, instalaciones y servicios destinados al tráfico regular de aeronaves.';


--
-- TOC entry 310 (class 1259 OID 2456955)
-- Name: aeropuerto_a_gid_seq; Type: SEQUENCE; Schema: a_aeropuerto_superficie; Owner: postgres
--

CREATE SEQUENCE a_aeropuerto_superficie.aeropuerto_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE a_aeropuerto_superficie.aeropuerto_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7452 (class 0 OID 0)
-- Dependencies: 310
-- Name: aeropuerto_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: a_aeropuerto_superficie; Owner: postgres
--

ALTER SEQUENCE a_aeropuerto_superficie.aeropuerto_a_gid_seq OWNED BY a_aeropuerto_superficie.aeropuerto_a.gid;


--
-- TOC entry 311 (class 1259 OID 2456956)
-- Name: acc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.acc (
    acc integer NOT NULL,
    acc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.acc OWNER TO postgres;

--
-- TOC entry 312 (class 1259 OID 2456959)
-- Name: atc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.atc (
    atc integer NOT NULL,
    atc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.atc OWNER TO postgres;

--
-- TOC entry 313 (class 1259 OID 2456962)
-- Name: bsc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.bsc (
    bsc integer NOT NULL,
    bsc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.bsc OWNER TO postgres;

--
-- TOC entry 314 (class 1259 OID 2456965)
-- Name: catalogo_objetos; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.catalogo_objetos (
    fcode character varying(5) NOT NULL,
    objeto character varying(80),
    descripcion character varying(350),
    gid integer NOT NULL
);


ALTER TABLE catalogo_objetos.catalogo_objetos OWNER TO postgres;

--
-- TOC entry 315 (class 1259 OID 2456968)
-- Name: catalogo_objetos_gid_seq; Type: SEQUENCE; Schema: catalogo_objetos; Owner: postgres
--

CREATE SEQUENCE catalogo_objetos.catalogo_objetos_gid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE catalogo_objetos.catalogo_objetos_gid_seq OWNER TO postgres;

--
-- TOC entry 7453 (class 0 OID 0)
-- Dependencies: 315
-- Name: catalogo_objetos_gid_seq; Type: SEQUENCE OWNED BY; Schema: catalogo_objetos; Owner: postgres
--

ALTER SEQUENCE catalogo_objetos.catalogo_objetos_gid_seq OWNED BY catalogo_objetos.catalogo_objetos.gid;


--
-- TOC entry 316 (class 1259 OID 2456969)
-- Name: dit; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.dit (
    dit integer NOT NULL,
    dit_desc character varying(80)
);


ALTER TABLE catalogo_objetos.dit OWNER TO postgres;

--
-- TOC entry 317 (class 1259 OID 2456972)
-- Name: ela; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.ela (
    ela integer NOT NULL,
    ela_desc character varying(80)
);


ALTER TABLE catalogo_objetos.ela OWNER TO postgres;

--
-- TOC entry 318 (class 1259 OID 2456975)
-- Name: fco; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.fco (
    fco integer NOT NULL,
    fco_desc character varying(80)
);


ALTER TABLE catalogo_objetos.fco OWNER TO postgres;

--
-- TOC entry 319 (class 1259 OID 2456978)
-- Name: fti; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.fti (
    fti integer NOT NULL,
    fti_desc character varying(80)
);


ALTER TABLE catalogo_objetos.fti OWNER TO postgres;

--
-- TOC entry 320 (class 1259 OID 2456981)
-- Name: fuc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.fuc (
    fuc integer NOT NULL,
    fuc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.fuc OWNER TO postgres;

--
-- TOC entry 321 (class 1259 OID 2456984)
-- Name: hct; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.hct (
    hct integer NOT NULL,
    hct_desc character varying(80)
);


ALTER TABLE catalogo_objetos.hct OWNER TO postgres;

--
-- TOC entry 322 (class 1259 OID 2456987)
-- Name: hyp; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.hyp (
    hyp integer NOT NULL,
    hyp_desc character varying(80)
);


ALTER TABLE catalogo_objetos.hyp OWNER TO postgres;

--
-- TOC entry 323 (class 1259 OID 2456990)
-- Name: kos; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.kos (
    kos integer NOT NULL,
    kos_desc character varying(80)
);


ALTER TABLE catalogo_objetos.kos OWNER TO postgres;

--
-- TOC entry 324 (class 1259 OID 2456993)
-- Name: loc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.loc (
    loc integer NOT NULL,
    loc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.loc OWNER TO postgres;

--
-- TOC entry 325 (class 1259 OID 2456996)
-- Name: mes; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.mes (
    mes integer NOT NULL,
    mes_desc character varying(80)
);


ALTER TABLE catalogo_objetos.mes OWNER TO postgres;

--
-- TOC entry 326 (class 1259 OID 2456999)
-- Name: rdt; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.rdt (
    rdt integer NOT NULL,
    rdt_desc character varying(80)
);


ALTER TABLE catalogo_objetos.rdt OWNER TO postgres;

--
-- TOC entry 327 (class 1259 OID 2457002)
-- Name: rel; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.rel (
    rel integer NOT NULL,
    rel_desc character varying(80)
);


ALTER TABLE catalogo_objetos.rel OWNER TO postgres;

--
-- TOC entry 328 (class 1259 OID 2457005)
-- Name: rgc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.rgc (
    rgc integer NOT NULL,
    rgc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.rgc OWNER TO postgres;

--
-- TOC entry 329 (class 1259 OID 2457008)
-- Name: rra; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.rra (
    rra integer NOT NULL,
    rra_desc character varying(80)
);


ALTER TABLE catalogo_objetos.rra OWNER TO postgres;

--
-- TOC entry 330 (class 1259 OID 2457011)
-- Name: rrc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.rrc (
    rrc integer NOT NULL,
    rrc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.rrc OWNER TO postgres;

--
-- TOC entry 331 (class 1259 OID 2457014)
-- Name: rst; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.rst (
    rst integer NOT NULL,
    rst_desc character varying(80)
);


ALTER TABLE catalogo_objetos.rst OWNER TO postgres;

--
-- TOC entry 332 (class 1259 OID 2457017)
-- Name: slt; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.slt (
    slt integer NOT NULL,
    slt_desc character varying(80)
);


ALTER TABLE catalogo_objetos.slt OWNER TO postgres;

--
-- TOC entry 333 (class 1259 OID 2457020)
-- Name: smc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.smc (
    smc integer NOT NULL,
    smc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.smc OWNER TO postgres;

--
-- TOC entry 334 (class 1259 OID 2457023)
-- Name: tra; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.tra (
    tra integer NOT NULL,
    tra_desc character varying(80)
);


ALTER TABLE catalogo_objetos.tra OWNER TO postgres;

--
-- TOC entry 335 (class 1259 OID 2457026)
-- Name: tuc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.tuc (
    tuc integer NOT NULL,
    tuc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.tuc OWNER TO postgres;

--
-- TOC entry 336 (class 1259 OID 2457029)
-- Name: typ; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.typ (
    typ integer NOT NULL,
    typ_desc character varying(80)
);


ALTER TABLE catalogo_objetos.typ OWNER TO postgres;

--
-- TOC entry 337 (class 1259 OID 2457032)
-- Name: uuc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.uuc (
    uuc integer NOT NULL,
    uuc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.uuc OWNER TO postgres;

--
-- TOC entry 338 (class 1259 OID 2457035)
-- Name: wtc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.wtc (
    wtc integer NOT NULL,
    wtc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.wtc OWNER TO postgres;

--
-- TOC entry 339 (class 1259 OID 2457038)
-- Name: wti; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.wti (
    wti integer NOT NULL,
    wti_desc character varying(80)
);


ALTER TABLE catalogo_objetos.wti OWNER TO postgres;

--
-- TOC entry 340 (class 1259 OID 2457041)
-- Name: punto_control_p; Type: TABLE; Schema: d_linderos_propiedad; Owner: postgres
--

CREATE TABLE d_linderos_propiedad.punto_control_p (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'ZB050'::character varying NOT NULL,
    acc integer NOT NULL,
    ela integer NOT NULL,
    zvh double precision,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'POINT'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32718)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'ZB050'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE d_linderos_propiedad.punto_control_p OWNER TO postgres;

--
-- TOC entry 7454 (class 0 OID 0)
-- Dependencies: 340
-- Name: TABLE punto_control_p; Type: COMMENT; Schema: d_linderos_propiedad; Owner: postgres
--

COMMENT ON TABLE d_linderos_propiedad.punto_control_p IS 'Objeto en el terreno de ubicación conocida, donde se ha determinado las coordenadas horizontal y/o vertical por métodos geodésicos o topográficos.';


--
-- TOC entry 341 (class 1259 OID 2457052)
-- Name: vertice_geodesico_p_gid_seq; Type: SEQUENCE; Schema: d_linderos_propiedad; Owner: postgres
--

CREATE SEQUENCE d_linderos_propiedad.vertice_geodesico_p_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE d_linderos_propiedad.vertice_geodesico_p_gid_seq OWNER TO postgres;

--
-- TOC entry 7455 (class 0 OID 0)
-- Dependencies: 341
-- Name: vertice_geodesico_p_gid_seq; Type: SEQUENCE OWNED BY; Schema: d_linderos_propiedad; Owner: postgres
--

ALTER SEQUENCE d_linderos_propiedad.vertice_geodesico_p_gid_seq OWNED BY d_linderos_propiedad.punto_control_p.gid;


--
-- TOC entry 342 (class 1259 OID 2457053)
-- Name: cementerio_a; Type: TABLE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE TABLE gs_asociado_poblados.cementerio_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AL030'::character varying NOT NULL,
    nam character varying(80),
    rel integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32718)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AL030'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_asociado_poblados.cementerio_a OWNER TO postgres;

--
-- TOC entry 7456 (class 0 OID 0)
-- Dependencies: 342
-- Name: TABLE cementerio_a; Type: COMMENT; Schema: gs_asociado_poblados; Owner: postgres
--

COMMENT ON TABLE gs_asociado_poblados.cementerio_a IS 'Sitio de estructuras asociadas, utilizadas para el entierro de muertos.';


--
-- TOC entry 343 (class 1259 OID 2457064)
-- Name: cementerio_a_gid_seq; Type: SEQUENCE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE SEQUENCE gs_asociado_poblados.cementerio_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_asociado_poblados.cementerio_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7457 (class 0 OID 0)
-- Dependencies: 343
-- Name: cementerio_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER SEQUENCE gs_asociado_poblados.cementerio_a_gid_seq OWNED BY gs_asociado_poblados.cementerio_a.gid;


--
-- TOC entry 344 (class 1259 OID 2457065)
-- Name: cerca_l; Type: TABLE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE TABLE gs_asociado_poblados.cerca_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AL070'::character varying NOT NULL,
    fti integer NOT NULL,
    wti integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32718)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AL070'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_asociado_poblados.cerca_l OWNER TO postgres;

--
-- TOC entry 7458 (class 0 OID 0)
-- Dependencies: 344
-- Name: TABLE cerca_l; Type: COMMENT; Schema: gs_asociado_poblados; Owner: postgres
--

COMMENT ON TABLE gs_asociado_poblados.cerca_l IS 'Barrera artificial construida por el hombre, de estructura relativamente liviana y que es utilizada como cercado o límite.';


--
-- TOC entry 345 (class 1259 OID 2457076)
-- Name: cerca_l_gid_seq; Type: SEQUENCE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE SEQUENCE gs_asociado_poblados.cerca_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_asociado_poblados.cerca_l_gid_seq OWNER TO postgres;

--
-- TOC entry 7459 (class 0 OID 0)
-- Dependencies: 345
-- Name: cerca_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER SEQUENCE gs_asociado_poblados.cerca_l_gid_seq OWNED BY gs_asociado_poblados.cerca_l.gid;


--
-- TOC entry 346 (class 1259 OID 2457077)
-- Name: escalinata_a; Type: TABLE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE TABLE gs_asociado_poblados.escalinata_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AQ150'::character varying NOT NULL,
    smc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32718)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AQ150'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_asociado_poblados.escalinata_a OWNER TO postgres;

--
-- TOC entry 7460 (class 0 OID 0)
-- Dependencies: 346
-- Name: TABLE escalinata_a; Type: COMMENT; Schema: gs_asociado_poblados; Owner: postgres
--

COMMENT ON TABLE gs_asociado_poblados.escalinata_a IS 'Serie de escalones que sirven para subir a un plano más elevado o para bajar a un plano inferior. Para fines catastrales se levantarán únicamente las escalinatas públicas que permitan identificar el lindero de un predio.';


--
-- TOC entry 347 (class 1259 OID 2457088)
-- Name: escalinata_a_gid_seq; Type: SEQUENCE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE SEQUENCE gs_asociado_poblados.escalinata_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_asociado_poblados.escalinata_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7461 (class 0 OID 0)
-- Dependencies: 347
-- Name: escalinata_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER SEQUENCE gs_asociado_poblados.escalinata_a_gid_seq OWNED BY gs_asociado_poblados.escalinata_a.gid;


--
-- TOC entry 348 (class 1259 OID 2457089)
-- Name: muro_l; Type: TABLE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE TABLE gs_asociado_poblados.muro_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AL260'::character varying NOT NULL,
    wti integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32718)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AL260'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_asociado_poblados.muro_l OWNER TO postgres;

--
-- TOC entry 7462 (class 0 OID 0)
-- Dependencies: 348
-- Name: TABLE muro_l; Type: COMMENT; Schema: gs_asociado_poblados; Owner: postgres
--

COMMENT ON TABLE gs_asociado_poblados.muro_l IS 'Barrera hecha por el hombre de material resistente y que es utilizado como límite o para protección. Es aquel objeto que permite identificar el lindero de un predio.';


--
-- TOC entry 349 (class 1259 OID 2457100)
-- Name: muro_l_gid_seq; Type: SEQUENCE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE SEQUENCE gs_asociado_poblados.muro_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_asociado_poblados.muro_l_gid_seq OWNER TO postgres;

--
-- TOC entry 7463 (class 0 OID 0)
-- Dependencies: 349
-- Name: muro_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER SEQUENCE gs_asociado_poblados.muro_l_gid_seq OWNED BY gs_asociado_poblados.muro_l.gid;


--
-- TOC entry 350 (class 1259 OID 2457101)
-- Name: plaza_publica_a; Type: TABLE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE TABLE gs_asociado_poblados.plaza_publica_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AL170'::character varying NOT NULL,
    nam character varying(80),
    smc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32718)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AL170'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_asociado_poblados.plaza_publica_a OWNER TO postgres;

--
-- TOC entry 7464 (class 0 OID 0)
-- Dependencies: 350
-- Name: TABLE plaza_publica_a; Type: COMMENT; Schema: gs_asociado_poblados; Owner: postgres
--

COMMENT ON TABLE gs_asociado_poblados.plaza_publica_a IS 'Sitio abierto que sirve como lugar de reunión pública, en una zona poblada para diversos usos.';


--
-- TOC entry 351 (class 1259 OID 2457112)
-- Name: plaza_publica_a_gid_seq; Type: SEQUENCE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE SEQUENCE gs_asociado_poblados.plaza_publica_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_asociado_poblados.plaza_publica_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7465 (class 0 OID 0)
-- Dependencies: 351
-- Name: plaza_publica_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER SEQUENCE gs_asociado_poblados.plaza_publica_a_gid_seq OWNED BY gs_asociado_poblados.plaza_publica_a.gid;


--
-- TOC entry 352 (class 1259 OID 2457113)
-- Name: edificio_a; Type: TABLE; Schema: gs_construcciones; Owner: postgres
--

CREATE TABLE gs_construcciones.edificio_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AL015'::character varying NOT NULL,
    nam character varying(200),
    acc integer NOT NULL,
    uuc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32718)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AL015'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_construcciones.edificio_a OWNER TO postgres;

--
-- TOC entry 7466 (class 0 OID 0)
-- Dependencies: 352
-- Name: TABLE edificio_a; Type: COMMENT; Schema: gs_construcciones; Owner: postgres
--

COMMENT ON TABLE gs_construcciones.edificio_a IS 'Construcción independiente, techada, generalmente con paredes; destinada al hábitat y/o actividades de personas. Para fines catastrales se incluye choza, misma que deberá ser catalogada en el atributo txt como "Choza".';


--
-- TOC entry 353 (class 1259 OID 2457124)
-- Name: edificio_a_gid_seq; Type: SEQUENCE; Schema: gs_construcciones; Owner: postgres
--

CREATE SEQUENCE gs_construcciones.edificio_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_construcciones.edificio_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7467 (class 0 OID 0)
-- Dependencies: 353
-- Name: edificio_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_construcciones; Owner: postgres
--

ALTER SEQUENCE gs_construcciones.edificio_a_gid_seq OWNED BY gs_construcciones.edificio_a.gid;


--
-- TOC entry 354 (class 1259 OID 2457125)
-- Name: cancha_a; Type: TABLE; Schema: gs_recreacion; Owner: postgres
--

CREATE TABLE gs_recreacion.cancha_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AK040'::character varying NOT NULL,
    nam character varying(80),
    smc integer NOT NULL,
    kos integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32718)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AK040'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_recreacion.cancha_a OWNER TO postgres;

--
-- TOC entry 7468 (class 0 OID 0)
-- Dependencies: 354
-- Name: TABLE cancha_a; Type: COMMENT; Schema: gs_recreacion; Owner: postgres
--

COMMENT ON TABLE gs_recreacion.cancha_a IS 'Lugar al aire libre destinado a eventos deportivos, ejercicio o juegos.';


--
-- TOC entry 355 (class 1259 OID 2457136)
-- Name: cancha_a_gid_seq; Type: SEQUENCE; Schema: gs_recreacion; Owner: postgres
--

CREATE SEQUENCE gs_recreacion.cancha_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_recreacion.cancha_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7469 (class 0 OID 0)
-- Dependencies: 355
-- Name: cancha_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_recreacion; Owner: postgres
--

ALTER SEQUENCE gs_recreacion.cancha_a_gid_seq OWNED BY gs_recreacion.cancha_a.gid;


--
-- TOC entry 356 (class 1259 OID 2457137)
-- Name: estadio_a; Type: TABLE; Schema: gs_recreacion; Owner: postgres
--

CREATE TABLE gs_recreacion.estadio_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AK165'::character varying NOT NULL,
    nam character varying(80),
    acc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32718)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AK165'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_recreacion.estadio_a OWNER TO postgres;

--
-- TOC entry 7470 (class 0 OID 0)
-- Dependencies: 356
-- Name: TABLE estadio_a; Type: COMMENT; Schema: gs_recreacion; Owner: postgres
--

COMMENT ON TABLE gs_recreacion.estadio_a IS 'Campo deportivo parcial o totalmente rodeado por una estructura diseñada para permitir a los espectadores ver un evento de pie o sentados; a menudo diseñados en forma y tamaño para dar cabida a deportes específicos (por ejemplo: el fútbol).';


--
-- TOC entry 357 (class 1259 OID 2457148)
-- Name: estadio_a_gid_seq; Type: SEQUENCE; Schema: gs_recreacion; Owner: postgres
--

CREATE SEQUENCE gs_recreacion.estadio_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_recreacion.estadio_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7471 (class 0 OID 0)
-- Dependencies: 357
-- Name: estadio_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_recreacion; Owner: postgres
--

ALTER SEQUENCE gs_recreacion.estadio_a_gid_seq OWNED BY gs_recreacion.estadio_a.gid;


--
-- TOC entry 358 (class 1259 OID 2457149)
-- Name: parque_a; Type: TABLE; Schema: gs_recreacion; Owner: postgres
--

CREATE TABLE gs_recreacion.parque_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AK120'::character varying NOT NULL,
    nam character varying(80),
    fuc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32718)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AK120'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_recreacion.parque_a OWNER TO postgres;

--
-- TOC entry 7472 (class 0 OID 0)
-- Dependencies: 358
-- Name: TABLE parque_a; Type: COMMENT; Schema: gs_recreacion; Owner: postgres
--

COMMENT ON TABLE gs_recreacion.parque_a IS 'Área utilizada con propósitos recreacionales u ornamentales.';


--
-- TOC entry 359 (class 1259 OID 2457160)
-- Name: parque_a_gid_seq; Type: SEQUENCE; Schema: gs_recreacion; Owner: postgres
--

CREATE SEQUENCE gs_recreacion.parque_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_recreacion.parque_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7473 (class 0 OID 0)
-- Dependencies: 359
-- Name: parque_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_recreacion; Owner: postgres
--

ALTER SEQUENCE gs_recreacion.parque_a_gid_seq OWNED BY gs_recreacion.parque_a.gid;


--
-- TOC entry 360 (class 1259 OID 2457161)
-- Name: piscina_a; Type: TABLE; Schema: gs_recreacion; Owner: postgres
--

CREATE TABLE gs_recreacion.piscina_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AK170'::character varying NOT NULL,
    nam character varying(80),
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32718)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AK170'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_recreacion.piscina_a OWNER TO postgres;

--
-- TOC entry 7474 (class 0 OID 0)
-- Dependencies: 360
-- Name: TABLE piscina_a; Type: COMMENT; Schema: gs_recreacion; Owner: postgres
--

COMMENT ON TABLE gs_recreacion.piscina_a IS 'Construcción destinada a contener agua con fines de recreación y natación.';


--
-- TOC entry 361 (class 1259 OID 2457172)
-- Name: piscina_a_gid_seq; Type: SEQUENCE; Schema: gs_recreacion; Owner: postgres
--

CREATE SEQUENCE gs_recreacion.piscina_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_recreacion.piscina_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7475 (class 0 OID 0)
-- Dependencies: 361
-- Name: piscina_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_recreacion; Owner: postgres
--

ALTER SEQUENCE gs_recreacion.piscina_a_gid_seq OWNED BY gs_recreacion.piscina_a.gid;


--
-- TOC entry 362 (class 1259 OID 2457173)
-- Name: plaza_toros_a; Type: TABLE; Schema: gs_recreacion; Owner: postgres
--

CREATE TABLE gs_recreacion.plaza_toros_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AK166'::character varying NOT NULL,
    nam character varying(80),
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32718)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AK166'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_recreacion.plaza_toros_a OWNER TO postgres;

--
-- TOC entry 7476 (class 0 OID 0)
-- Dependencies: 362
-- Name: TABLE plaza_toros_a; Type: COMMENT; Schema: gs_recreacion; Owner: postgres
--

COMMENT ON TABLE gs_recreacion.plaza_toros_a IS 'Construcción generalmente circular u ovalada, de cielo abierto, rodeada por graderíos para los espectadores.';


--
-- TOC entry 363 (class 1259 OID 2457184)
-- Name: plaza_toros_a_gid_seq; Type: SEQUENCE; Schema: gs_recreacion; Owner: postgres
--

CREATE SEQUENCE gs_recreacion.plaza_toros_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_recreacion.plaza_toros_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7477 (class 0 OID 0)
-- Dependencies: 363
-- Name: plaza_toros_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_recreacion; Owner: postgres
--

ALTER SEQUENCE gs_recreacion.plaza_toros_a_gid_seq OWNED BY gs_recreacion.plaza_toros_a.gid;


--
-- TOC entry 364 (class 1259 OID 2457185)
-- Name: acequia_l; Type: TABLE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE TABLE ho_aguas_interiores.acequia_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BH030'::character varying NOT NULL,
    hyp integer NOT NULL,
    dit integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32718)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BH030'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_aguas_interiores.acequia_l OWNER TO postgres;

--
-- TOC entry 7478 (class 0 OID 0)
-- Dependencies: 364
-- Name: TABLE acequia_l; Type: COMMENT; Schema: ho_aguas_interiores; Owner: postgres
--

COMMENT ON TABLE ho_aguas_interiores.acequia_l IS 'Excavación poco profunda construida en tierra con propósitos de drenaje o irrigación. Se debe levantar los dos lados de la acequia, no únicamente el eje. ';


--
-- TOC entry 365 (class 1259 OID 2457196)
-- Name: acequia_l_gid_seq; Type: SEQUENCE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE SEQUENCE ho_aguas_interiores.acequia_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_aguas_interiores.acequia_l_gid_seq OWNER TO postgres;

--
-- TOC entry 7479 (class 0 OID 0)
-- Dependencies: 365
-- Name: acequia_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER SEQUENCE ho_aguas_interiores.acequia_l_gid_seq OWNED BY ho_aguas_interiores.acequia_l.gid;


--
-- TOC entry 366 (class 1259 OID 2457197)
-- Name: acueducto_canal_a; Type: TABLE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE TABLE ho_aguas_interiores.acueducto_canal_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BH010'::character varying NOT NULL,
    atc integer NOT NULL,
    smc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32718)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BH010'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_aguas_interiores.acueducto_canal_a OWNER TO postgres;

--
-- TOC entry 7480 (class 0 OID 0)
-- Dependencies: 366
-- Name: TABLE acueducto_canal_a; Type: COMMENT; Schema: ho_aguas_interiores; Owner: postgres
--

COMMENT ON TABLE ho_aguas_interiores.acueducto_canal_a IS 'Cauce artificial que transporta agua en forma de flujo continuo desde un lugar en el que ésta es accesible para consumo u otros usos. ';


--
-- TOC entry 367 (class 1259 OID 2457208)
-- Name: acueducto_canal_a_gid_seq; Type: SEQUENCE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE SEQUENCE ho_aguas_interiores.acueducto_canal_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_aguas_interiores.acueducto_canal_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7481 (class 0 OID 0)
-- Dependencies: 367
-- Name: acueducto_canal_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER SEQUENCE ho_aguas_interiores.acueducto_canal_a_gid_seq OWNED BY ho_aguas_interiores.acueducto_canal_a.gid;


--
-- TOC entry 368 (class 1259 OID 2457209)
-- Name: lago_laguna_a; Type: TABLE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE TABLE ho_aguas_interiores.lago_laguna_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BH080'::character varying NOT NULL,
    nam character varying(80),
    na2 character varying(80),
    hyp integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32718)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BH080'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_aguas_interiores.lago_laguna_a OWNER TO postgres;

--
-- TOC entry 7482 (class 0 OID 0)
-- Dependencies: 368
-- Name: TABLE lago_laguna_a; Type: COMMENT; Schema: ho_aguas_interiores; Owner: postgres
--

COMMENT ON TABLE ho_aguas_interiores.lago_laguna_a IS 'Cuerpo de agua, dulce o salada que se encuentra rodeada por tierra.';


--
-- TOC entry 369 (class 1259 OID 2457220)
-- Name: lago_laguna_a_gid_seq; Type: SEQUENCE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE SEQUENCE ho_aguas_interiores.lago_laguna_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_aguas_interiores.lago_laguna_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7483 (class 0 OID 0)
-- Dependencies: 369
-- Name: lago_laguna_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER SEQUENCE ho_aguas_interiores.lago_laguna_a_gid_seq OWNED BY ho_aguas_interiores.lago_laguna_a.gid;


--
-- TOC entry 370 (class 1259 OID 2457221)
-- Name: rio_a; Type: TABLE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE TABLE ho_aguas_interiores.rio_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BH140'::character varying NOT NULL,
    nam character varying(100),
    na2 character varying(80),
    acc integer NOT NULL,
    hyp integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32718)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BH140'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_aguas_interiores.rio_a OWNER TO postgres;

--
-- TOC entry 7484 (class 0 OID 0)
-- Dependencies: 370
-- Name: TABLE rio_a; Type: COMMENT; Schema: ho_aguas_interiores; Owner: postgres
--

COMMENT ON TABLE ho_aguas_interiores.rio_a IS 'Curso de agua que fluye naturalmente.';


--
-- TOC entry 371 (class 1259 OID 2457232)
-- Name: rio_a_gid_seq; Type: SEQUENCE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE SEQUENCE ho_aguas_interiores.rio_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_aguas_interiores.rio_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7485 (class 0 OID 0)
-- Dependencies: 371
-- Name: rio_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER SEQUENCE ho_aguas_interiores.rio_a_gid_seq OWNED BY ho_aguas_interiores.rio_a.gid;


--
-- TOC entry 372 (class 1259 OID 2457233)
-- Name: rio_l; Type: TABLE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE TABLE ho_aguas_interiores.rio_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BH140'::character varying NOT NULL,
    nam character varying(100),
    na2 character varying(80),
    acc integer NOT NULL,
    hyp integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32718)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BH140'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_aguas_interiores.rio_l OWNER TO postgres;

--
-- TOC entry 7486 (class 0 OID 0)
-- Dependencies: 372
-- Name: TABLE rio_l; Type: COMMENT; Schema: ho_aguas_interiores; Owner: postgres
--

COMMENT ON TABLE ho_aguas_interiores.rio_l IS 'Curso de agua que fluye naturalmente.';


--
-- TOC entry 373 (class 1259 OID 2457244)
-- Name: rio_l_gid_seq; Type: SEQUENCE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE SEQUENCE ho_aguas_interiores.rio_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_aguas_interiores.rio_l_gid_seq OWNER TO postgres;

--
-- TOC entry 7487 (class 0 OID 0)
-- Dependencies: 373
-- Name: rio_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER SEQUENCE ho_aguas_interiores.rio_l_gid_seq OWNED BY ho_aguas_interiores.rio_l.gid;


--
-- TOC entry 374 (class 1259 OID 2457245)
-- Name: zanja_l; Type: TABLE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE TABLE ho_aguas_interiores.zanja_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BH100'::character varying NOT NULL,
    hyp integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32718)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BH100'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_aguas_interiores.zanja_l OWNER TO postgres;

--
-- TOC entry 7488 (class 0 OID 0)
-- Dependencies: 374
-- Name: TABLE zanja_l; Type: COMMENT; Schema: ho_aguas_interiores; Owner: postgres
--

COMMENT ON TABLE ho_aguas_interiores.zanja_l IS 'Excavación larga y estrecha que se hace en la tierra para echar los cimientos, conducir las aguas, defender los sembríos o usos semejantes. Se debe levantar los dos lados de la zanja, no únicamente el eje. ';


--
-- TOC entry 375 (class 1259 OID 2457256)
-- Name: zanja_l_gid_seq; Type: SEQUENCE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE SEQUENCE ho_aguas_interiores.zanja_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_aguas_interiores.zanja_l_gid_seq OWNER TO postgres;

--
-- TOC entry 7489 (class 0 OID 0)
-- Dependencies: 375
-- Name: zanja_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER SEQUENCE ho_aguas_interiores.zanja_l_gid_seq OWNED BY ho_aguas_interiores.zanja_l.gid;


--
-- TOC entry 376 (class 1259 OID 2457257)
-- Name: puerto_a; Type: TABLE; Schema: ho_puertos_muelles; Owner: postgres
--

CREATE TABLE ho_puertos_muelles.puerto_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BB005'::character varying NOT NULL,
    nam character varying(80),
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32718)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BB005'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_puertos_muelles.puerto_a OWNER TO postgres;

--
-- TOC entry 7490 (class 0 OID 0)
-- Dependencies: 376
-- Name: TABLE puerto_a; Type: COMMENT; Schema: ho_puertos_muelles; Owner: postgres
--

COMMENT ON TABLE ho_puertos_muelles.puerto_a IS 'Conjunto de obras, instalaciones y servicios que proporcionan el espacio necesario para la estancia de los buques mientras realizan operaciones de carga, descarga, almacenaje y tránsito de pasajeros.';


--
-- TOC entry 377 (class 1259 OID 2457268)
-- Name: puerto_a_gid_seq; Type: SEQUENCE; Schema: ho_puertos_muelles; Owner: postgres
--

CREATE SEQUENCE ho_puertos_muelles.puerto_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_puertos_muelles.puerto_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7491 (class 0 OID 0)
-- Dependencies: 377
-- Name: puerto_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_puertos_muelles; Owner: postgres
--

ALTER SEQUENCE ho_puertos_muelles.puerto_a_gid_seq OWNED BY ho_puertos_muelles.puerto_a.gid;


--
-- TOC entry 378 (class 1259 OID 2457269)
-- Name: granja_acuatica_a; Type: TABLE; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--

CREATE TABLE ho_regulacion_zonas_restringidas.granja_acuatica_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BH050'::character varying NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32718)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BH050'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_regulacion_zonas_restringidas.granja_acuatica_a OWNER TO postgres;

--
-- TOC entry 7492 (class 0 OID 0)
-- Dependencies: 378
-- Name: TABLE granja_acuatica_a; Type: COMMENT; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--

COMMENT ON TABLE ho_regulacion_zonas_restringidas.granja_acuatica_a IS 'Área cerrada de agua utilizada para la reproducción o cría de camarones, peces y similares. ';


--
-- TOC entry 379 (class 1259 OID 2457280)
-- Name: granja_acuatica_a_gid_seq; Type: SEQUENCE; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--

CREATE SEQUENCE ho_regulacion_zonas_restringidas.granja_acuatica_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_regulacion_zonas_restringidas.granja_acuatica_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7493 (class 0 OID 0)
-- Dependencies: 379
-- Name: granja_acuatica_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--

ALTER SEQUENCE ho_regulacion_zonas_restringidas.granja_acuatica_a_gid_seq OWNED BY ho_regulacion_zonas_restringidas.granja_acuatica_a.gid;


--
-- TOC entry 380 (class 1259 OID 2457281)
-- Name: isla_a; Type: TABLE; Schema: ho_zonas_costeras; Owner: postgres
--

CREATE TABLE ho_zonas_costeras.isla_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BA030'::character varying NOT NULL,
    nam character varying(80),
    na2 character varying(80),
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32718)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BA030'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_zonas_costeras.isla_a OWNER TO postgres;

--
-- TOC entry 7494 (class 0 OID 0)
-- Dependencies: 380
-- Name: TABLE isla_a; Type: COMMENT; Schema: ho_zonas_costeras; Owner: postgres
--

COMMENT ON TABLE ho_zonas_costeras.isla_a IS 'Masa de tierra más pequeña que un continente y que está rodeada por agua.';


--
-- TOC entry 381 (class 1259 OID 2457292)
-- Name: isla_a_gid_seq; Type: SEQUENCE; Schema: ho_zonas_costeras; Owner: postgres
--

CREATE SEQUENCE ho_zonas_costeras.isla_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_zonas_costeras.isla_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7495 (class 0 OID 0)
-- Dependencies: 381
-- Name: isla_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_zonas_costeras; Owner: postgres
--

ALTER SEQUENCE ho_zonas_costeras.isla_a_gid_seq OWNED BY ho_zonas_costeras.isla_a.gid;


--
-- TOC entry 382 (class 1259 OID 2457293)
-- Name: orilla_l; Type: TABLE; Schema: ho_zonas_costeras; Owner: postgres
--

CREATE TABLE ho_zonas_costeras.orilla_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BA010'::character varying NOT NULL,
    acc integer NOT NULL,
    slt integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32718)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BA010'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_zonas_costeras.orilla_l OWNER TO postgres;

--
-- TOC entry 7496 (class 0 OID 0)
-- Dependencies: 382
-- Name: TABLE orilla_l; Type: COMMENT; Schema: ho_zonas_costeras; Owner: postgres
--

COMMENT ON TABLE ho_zonas_costeras.orilla_l IS 'Línea donde una superficie está en contacto con un cuerpo de agua. ';


--
-- TOC entry 383 (class 1259 OID 2457304)
-- Name: orilla_l_gid_seq; Type: SEQUENCE; Schema: ho_zonas_costeras; Owner: postgres
--

CREATE SEQUENCE ho_zonas_costeras.orilla_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_zonas_costeras.orilla_l_gid_seq OWNER TO postgres;

--
-- TOC entry 7497 (class 0 OID 0)
-- Dependencies: 383
-- Name: orilla_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_zonas_costeras; Owner: postgres
--

ALTER SEQUENCE ho_zonas_costeras.orilla_l_gid_seq OWNED BY ho_zonas_costeras.orilla_l.gid;


--
-- TOC entry 384 (class 1259 OID 2457305)
-- Name: invernadero_a; Type: TABLE; Schema: ii_agropecuaria; Owner: postgres
--

CREATE TABLE ii_agropecuaria.invernadero_a (
    gid integer DEFAULT nextval(('ii_agropecuaria.invernadero_a_gid_seq'::text)::regclass) NOT NULL,
    fcode character varying(5) DEFAULT 'AJ110'::character varying NOT NULL,
    nam character varying(80),
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32718)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AJ110'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ii_agropecuaria.invernadero_a OWNER TO postgres;

--
-- TOC entry 7498 (class 0 OID 0)
-- Dependencies: 384
-- Name: TABLE invernadero_a; Type: COMMENT; Schema: ii_agropecuaria; Owner: postgres
--

COMMENT ON TABLE ii_agropecuaria.invernadero_a IS 'Edificio construido principalmente de material transparente en el que la temperatura y la humedad puede ser controlada para el cultivo y/o protección de plantas.';


--
-- TOC entry 385 (class 1259 OID 2457317)
-- Name: invernadero_a_gid_seq; Type: SEQUENCE; Schema: ii_agropecuaria; Owner: postgres
--

CREATE SEQUENCE ii_agropecuaria.invernadero_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ii_agropecuaria.invernadero_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7499 (class 0 OID 0)
-- Dependencies: 385
-- Name: invernadero_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: ii_agropecuaria; Owner: postgres
--

ALTER SEQUENCE ii_agropecuaria.invernadero_a_gid_seq OWNED BY ii_agropecuaria.invernadero_a.gid;


--
-- TOC entry 386 (class 1259 OID 2457318)
-- Name: acera_a; Type: TABLE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE TABLE it_asociado_transportacion.acera_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AQ035'::character varying NOT NULL,
    smc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32718)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AQ035'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_asociado_transportacion.acera_a OWNER TO postgres;

--
-- TOC entry 7500 (class 0 OID 0)
-- Dependencies: 386
-- Name: TABLE acera_a; Type: COMMENT; Schema: it_asociado_transportacion; Owner: postgres
--

COMMENT ON TABLE it_asociado_transportacion.acera_a IS 'Ruta pavimentada o mejorada para uso del peatón, normalmente se encuentra adyacente y paralela a una calle o carretera. ';


--
-- TOC entry 387 (class 1259 OID 2457329)
-- Name: acera_a_gid_seq; Type: SEQUENCE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE SEQUENCE it_asociado_transportacion.acera_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_asociado_transportacion.acera_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7501 (class 0 OID 0)
-- Dependencies: 387
-- Name: acera_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER SEQUENCE it_asociado_transportacion.acera_a_gid_seq OWNED BY it_asociado_transportacion.acera_a.gid;


--
-- TOC entry 388 (class 1259 OID 2457330)
-- Name: bordillo_l; Type: TABLE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE TABLE it_asociado_transportacion.bordillo_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AQ037'::character varying NOT NULL,
    smc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32718)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AQ037'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_asociado_transportacion.bordillo_l OWNER TO postgres;

--
-- TOC entry 7502 (class 0 OID 0)
-- Dependencies: 388
-- Name: TABLE bordillo_l; Type: COMMENT; Schema: it_asociado_transportacion; Owner: postgres
--

COMMENT ON TABLE it_asociado_transportacion.bordillo_l IS 'Borde de hormigón, asfalto o piedras que forman el borde de una acera a lo largo de la orilla de una calle o carretera. Se debe incluir aquellos que formen parte de los parterres.';


--
-- TOC entry 389 (class 1259 OID 2457341)
-- Name: bordillo_l_gid_seq; Type: SEQUENCE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE SEQUENCE it_asociado_transportacion.bordillo_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_asociado_transportacion.bordillo_l_gid_seq OWNER TO postgres;

--
-- TOC entry 7503 (class 0 OID 0)
-- Dependencies: 389
-- Name: bordillo_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER SEQUENCE it_asociado_transportacion.bordillo_l_gid_seq OWNED BY it_asociado_transportacion.bordillo_l.gid;


--
-- TOC entry 390 (class 1259 OID 2457342)
-- Name: cuneta_a; Type: TABLE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE TABLE it_asociado_transportacion.cuneta_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AQ036'::character varying NOT NULL,
    smc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry(MultiPolygon,32718) NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32718)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AQ036'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_asociado_transportacion.cuneta_a OWNER TO postgres;

--
-- TOC entry 7504 (class 0 OID 0)
-- Dependencies: 390
-- Name: TABLE cuneta_a; Type: COMMENT; Schema: it_asociado_transportacion; Owner: postgres
--

COMMENT ON TABLE it_asociado_transportacion.cuneta_a IS 'Borde de hormigón, asfalto o piedras que forman parte de un canal a lo largo del borde de una calle o carretera. Este objeto tiene el fin de canalizar agua de lluvia que se escurra a lo largo de la vía.';


--
-- TOC entry 391 (class 1259 OID 2457353)
-- Name: cuneta_a_gid_seq; Type: SEQUENCE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE SEQUENCE it_asociado_transportacion.cuneta_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_asociado_transportacion.cuneta_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7505 (class 0 OID 0)
-- Dependencies: 391
-- Name: cuneta_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER SEQUENCE it_asociado_transportacion.cuneta_a_gid_seq OWNED BY it_asociado_transportacion.cuneta_a.gid;


--
-- TOC entry 392 (class 1259 OID 2457354)
-- Name: parqueadero_a; Type: TABLE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE TABLE it_asociado_transportacion.parqueadero_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AQ140'::character varying NOT NULL,
    nam character varying(80),
    smc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32718)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AQ140'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_asociado_transportacion.parqueadero_a OWNER TO postgres;

--
-- TOC entry 7506 (class 0 OID 0)
-- Dependencies: 392
-- Name: TABLE parqueadero_a; Type: COMMENT; Schema: it_asociado_transportacion; Owner: postgres
--

COMMENT ON TABLE it_asociado_transportacion.parqueadero_a IS 'Lugar destinado generalmente para estacionar vehículos.';


--
-- TOC entry 393 (class 1259 OID 2457365)
-- Name: parqueadero_a_gid_seq; Type: SEQUENCE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE SEQUENCE it_asociado_transportacion.parqueadero_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_asociado_transportacion.parqueadero_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7507 (class 0 OID 0)
-- Dependencies: 393
-- Name: parqueadero_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER SEQUENCE it_asociado_transportacion.parqueadero_a_gid_seq OWNED BY it_asociado_transportacion.parqueadero_a.gid;


--
-- TOC entry 394 (class 1259 OID 2457366)
-- Name: paseo_peatonal_ciclovia_a; Type: TABLE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE TABLE it_asociado_transportacion.paseo_peatonal_ciclovia_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AP031'::character varying NOT NULL,
    nam character varying(80),
    smc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32718)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AP031'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_asociado_transportacion.paseo_peatonal_ciclovia_a OWNER TO postgres;

--
-- TOC entry 7508 (class 0 OID 0)
-- Dependencies: 394
-- Name: TABLE paseo_peatonal_ciclovia_a; Type: COMMENT; Schema: it_asociado_transportacion; Owner: postgres
--

COMMENT ON TABLE it_asociado_transportacion.paseo_peatonal_ciclovia_a IS 'Franja de terreno pavimentada o mejorada que tiene por objeto servir como una vía para peatones, animales y/o vehículos no motorizado.';


--
-- TOC entry 395 (class 1259 OID 2457377)
-- Name: paseo_peatonal_ciclovia_a_gid_seq; Type: SEQUENCE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE SEQUENCE it_asociado_transportacion.paseo_peatonal_ciclovia_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_asociado_transportacion.paseo_peatonal_ciclovia_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7509 (class 0 OID 0)
-- Dependencies: 395
-- Name: paseo_peatonal_ciclovia_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER SEQUENCE it_asociado_transportacion.paseo_peatonal_ciclovia_a_gid_seq OWNED BY it_asociado_transportacion.paseo_peatonal_ciclovia_a.gid;


--
-- TOC entry 396 (class 1259 OID 2457378)
-- Name: tunel_a; Type: TABLE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE TABLE it_asociado_transportacion.tunel_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AQ130'::character varying NOT NULL,
    nam character varying(80),
    tra integer NOT NULL,
    tuc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry(MultiPolygon,32718) NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32718)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AQ130'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_asociado_transportacion.tunel_a OWNER TO postgres;

--
-- TOC entry 7510 (class 0 OID 0)
-- Dependencies: 396
-- Name: TABLE tunel_a; Type: COMMENT; Schema: it_asociado_transportacion; Owner: postgres
--

COMMENT ON TABLE it_asociado_transportacion.tunel_a IS 'Paso subterráneo o submarino, abierto para establecer comunicación.';


--
-- TOC entry 397 (class 1259 OID 2457389)
-- Name: tunel_a_gid_seq; Type: SEQUENCE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE SEQUENCE it_asociado_transportacion.tunel_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_asociado_transportacion.tunel_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7511 (class 0 OID 0)
-- Dependencies: 397
-- Name: tunel_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER SEQUENCE it_asociado_transportacion.tunel_a_gid_seq OWNED BY it_asociado_transportacion.tunel_a.gid;


--
-- TOC entry 398 (class 1259 OID 2457390)
-- Name: puente_a; Type: TABLE; Schema: it_cruces_enlaces; Owner: postgres
--

CREATE TABLE it_cruces_enlaces.puente_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AQ040'::character varying NOT NULL,
    nam character varying(80),
    na2 character varying(80),
    acc integer NOT NULL,
    bsc integer NOT NULL,
    ltn integer NOT NULL,
    typ integer NOT NULL,
    tuc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32718)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AQ040'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_cruces_enlaces.puente_a OWNER TO postgres;

--
-- TOC entry 7512 (class 0 OID 0)
-- Dependencies: 398
-- Name: TABLE puente_a; Type: COMMENT; Schema: it_cruces_enlaces; Owner: postgres
--

COMMENT ON TABLE it_cruces_enlaces.puente_a IS 'Estructura que conecta dos lugares y facilita el paso de una ruta de transporte (por ejemplo: carretera o ferrocarril) sobre un obstáculo del terreno (por ejemplo: cuerpo de agua, barranco y/o carretera).';


--
-- TOC entry 399 (class 1259 OID 2457401)
-- Name: puente_a_gid_seq; Type: SEQUENCE; Schema: it_cruces_enlaces; Owner: postgres
--

CREATE SEQUENCE it_cruces_enlaces.puente_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_cruces_enlaces.puente_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7513 (class 0 OID 0)
-- Dependencies: 399
-- Name: puente_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_cruces_enlaces; Owner: postgres
--

ALTER SEQUENCE it_cruces_enlaces.puente_a_gid_seq OWNED BY it_cruces_enlaces.puente_a.gid;


--
-- TOC entry 400 (class 1259 OID 2457402)
-- Name: ferrocarril_a; Type: TABLE; Schema: it_ferrocarriles; Owner: postgres
--

CREATE TABLE it_ferrocarriles.ferrocarril_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AN010'::character varying NOT NULL,
    nam character varying(80),
    acc integer NOT NULL,
    fco integer NOT NULL,
    loc integer NOT NULL,
    ltn integer NOT NULL,
    rgc integer NOT NULL,
    rra integer NOT NULL,
    rrc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry(MultiPolygon,32718) NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32718)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AN010'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_ferrocarriles.ferrocarril_a OWNER TO postgres;

--
-- TOC entry 7514 (class 0 OID 0)
-- Dependencies: 400
-- Name: TABLE ferrocarril_a; Type: COMMENT; Schema: it_ferrocarriles; Owner: postgres
--

COMMENT ON TABLE it_ferrocarriles.ferrocarril_a IS 'Una o más vías de ferrocarril que comprende una red utilizada para el transporte de pasajeros y/o bienes.';


--
-- TOC entry 401 (class 1259 OID 2457413)
-- Name: ferrocarril_a_gid_seq; Type: SEQUENCE; Schema: it_ferrocarriles; Owner: postgres
--

CREATE SEQUENCE it_ferrocarriles.ferrocarril_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_ferrocarriles.ferrocarril_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7515 (class 0 OID 0)
-- Dependencies: 401
-- Name: ferrocarril_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_ferrocarriles; Owner: postgres
--

ALTER SEQUENCE it_ferrocarriles.ferrocarril_a_gid_seq OWNED BY it_ferrocarriles.ferrocarril_a.gid;


--
-- TOC entry 402 (class 1259 OID 2457414)
-- Name: gasolinera_a; Type: TABLE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE TABLE it_transporte_terrestre.gasolinera_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AQ170'::character varying NOT NULL,
    nam character varying(80),
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32718)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AQ170'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_transporte_terrestre.gasolinera_a OWNER TO postgres;

--
-- TOC entry 7516 (class 0 OID 0)
-- Dependencies: 402
-- Name: TABLE gasolinera_a; Type: COMMENT; Schema: it_transporte_terrestre; Owner: postgres
--

COMMENT ON TABLE it_transporte_terrestre.gasolinera_a IS 'Establecimiento en el cual se vende combustible y lubricantes generalmente para vehículos de motor.';


--
-- TOC entry 403 (class 1259 OID 2457425)
-- Name: gasolinera_a_gid_seq; Type: SEQUENCE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE SEQUENCE it_transporte_terrestre.gasolinera_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_transporte_terrestre.gasolinera_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7517 (class 0 OID 0)
-- Dependencies: 403
-- Name: gasolinera_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER SEQUENCE it_transporte_terrestre.gasolinera_a_gid_seq OWNED BY it_transporte_terrestre.gasolinera_a.gid;


--
-- TOC entry 404 (class 1259 OID 2457426)
-- Name: intercambiador_vial_a; Type: TABLE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE TABLE it_transporte_terrestre.intercambiador_vial_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AP020'::character varying NOT NULL,
    nam character varying(80),
    hct integer NOT NULL,
    rst integer NOT NULL,
    loc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32718)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AP020'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_transporte_terrestre.intercambiador_vial_a OWNER TO postgres;

--
-- TOC entry 7518 (class 0 OID 0)
-- Dependencies: 404
-- Name: TABLE intercambiador_vial_a; Type: COMMENT; Schema: it_transporte_terrestre; Owner: postgres
--

COMMENT ON TABLE it_transporte_terrestre.intercambiador_vial_a IS 'Conexión diseñada para facilitar el acceso del tráfico de una carretera a otra.';


--
-- TOC entry 405 (class 1259 OID 2457437)
-- Name: intercambiador_vial_a_gid_seq; Type: SEQUENCE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE SEQUENCE it_transporte_terrestre.intercambiador_vial_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_transporte_terrestre.intercambiador_vial_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7519 (class 0 OID 0)
-- Dependencies: 405
-- Name: intercambiador_vial_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER SEQUENCE it_transporte_terrestre.intercambiador_vial_a_gid_seq OWNED BY it_transporte_terrestre.intercambiador_vial_a.gid;


--
-- TOC entry 406 (class 1259 OID 2457438)
-- Name: rodera_l; Type: TABLE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE TABLE it_transporte_terrestre.rodera_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AP010'::character varying NOT NULL,
    typ integer NOT NULL,
    rst integer NOT NULL,
    hct integer NOT NULL,
    rdt integer,
    wtc integer NOT NULL,
    ltn integer NOT NULL,
    tuc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32718)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AP010'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_transporte_terrestre.rodera_l OWNER TO postgres;

--
-- TOC entry 7520 (class 0 OID 0)
-- Dependencies: 406
-- Name: TABLE rodera_l; Type: COMMENT; Schema: it_transporte_terrestre; Owner: postgres
--

COMMENT ON TABLE it_transporte_terrestre.rodera_l IS 'Vía natural con poca o ninguna mejora por la que pueden transitar vehículos de doble tracción.';


--
-- TOC entry 407 (class 1259 OID 2457449)
-- Name: rodera_l_gid_seq; Type: SEQUENCE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE SEQUENCE it_transporte_terrestre.rodera_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_transporte_terrestre.rodera_l_gid_seq OWNER TO postgres;

--
-- TOC entry 7521 (class 0 OID 0)
-- Dependencies: 407
-- Name: rodera_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER SEQUENCE it_transporte_terrestre.rodera_l_gid_seq OWNED BY it_transporte_terrestre.rodera_l.gid;


--
-- TOC entry 408 (class 1259 OID 2457450)
-- Name: sendero_l; Type: TABLE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE TABLE it_transporte_terrestre.sendero_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AP050'::character varying NOT NULL,
    wtc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32718)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AP050'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_transporte_terrestre.sendero_l OWNER TO postgres;

--
-- TOC entry 7522 (class 0 OID 0)
-- Dependencies: 408
-- Name: TABLE sendero_l; Type: COMMENT; Schema: it_transporte_terrestre; Owner: postgres
--

COMMENT ON TABLE it_transporte_terrestre.sendero_l IS 'Camino angosto abierto por el tránsito de personas o animales.';


--
-- TOC entry 409 (class 1259 OID 2457461)
-- Name: sendero_l_gid_seq; Type: SEQUENCE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE SEQUENCE it_transporte_terrestre.sendero_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_transporte_terrestre.sendero_l_gid_seq OWNER TO postgres;

--
-- TOC entry 7523 (class 0 OID 0)
-- Dependencies: 409
-- Name: sendero_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER SEQUENCE it_transporte_terrestre.sendero_l_gid_seq OWNED BY it_transporte_terrestre.sendero_l.gid;


--
-- TOC entry 410 (class 1259 OID 2457462)
-- Name: via_ruta_a; Type: TABLE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE TABLE it_transporte_terrestre.via_ruta_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AP030'::character varying NOT NULL,
    nam character varying(80),
    na2 character varying(80),
    acc integer NOT NULL,
    rst integer NOT NULL,
    typ integer NOT NULL,
    hct integer NOT NULL,
    loc integer NOT NULL,
    ltn integer NOT NULL,
    mes integer NOT NULL,
    rdt integer,
    tuc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32718)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AP030'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_transporte_terrestre.via_ruta_a OWNER TO postgres;

--
-- TOC entry 7524 (class 0 OID 0)
-- Dependencies: 410
-- Name: TABLE via_ruta_a; Type: COMMENT; Schema: it_transporte_terrestre; Owner: postgres
--

COMMENT ON TABLE it_transporte_terrestre.via_ruta_a IS 'Trayecto con una superficie especialmente preparada que se mantiene para ser usada por vehículos generalmente a motor. ';


--
-- TOC entry 411 (class 1259 OID 2457473)
-- Name: via_ruta_a_gid_seq; Type: SEQUENCE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE SEQUENCE it_transporte_terrestre.via_ruta_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_transporte_terrestre.via_ruta_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7525 (class 0 OID 0)
-- Dependencies: 411
-- Name: via_ruta_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER SEQUENCE it_transporte_terrestre.via_ruta_a_gid_seq OWNED BY it_transporte_terrestre.via_ruta_a.gid;


--
-- TOC entry 412 (class 1259 OID 2457474)
-- Name: qgis_projects; Type: TABLE; Schema: proyecto_qgis3; Owner: postgres
--

CREATE TABLE proyecto_qgis3.qgis_projects (
    name text NOT NULL,
    metadata jsonb,
    content bytea
);


ALTER TABLE proyecto_qgis3.qgis_projects OWNER TO postgres;

--
-- TOC entry 413 (class 1259 OID 2457479)
-- Name: acequia_l; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.acequia_l AS
 SELECT acequia_l.gid,
    acequia_l.fcode,
    catalogo_objetos.descripcion,
    hyp.hyp_desc,
    dit.dit_desc,
    acequia_l.txt,
    (acequia_l.the_geom)::public.geometry(LineString,32718) AS the_geom
   FROM (((ho_aguas_interiores.acequia_l
     JOIN catalogo_objetos.hyp ON ((acequia_l.hyp = hyp.hyp)))
     JOIN catalogo_objetos.dit ON ((acequia_l.dit = dit.dit)))
     JOIN catalogo_objetos.catalogo_objetos ON (((acequia_l.fcode)::text = (catalogo_objetos.fcode)::text)));


ALTER TABLE visualizacion.acequia_l OWNER TO postgres;

--
-- TOC entry 414 (class 1259 OID 2457484)
-- Name: acera_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.acera_a AS
 SELECT acera_a.gid,
    acera_a.fcode,
    catalogo_objetos.descripcion,
    smc.smc_desc,
    acera_a.txt,
    (acera_a.the_geom)::public.geometry(MultiPolygon,32718) AS the_geom
   FROM ((it_asociado_transportacion.acera_a
     JOIN catalogo_objetos.catalogo_objetos ON (((acera_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.smc ON ((acera_a.smc = smc.smc)));


ALTER TABLE visualizacion.acera_a OWNER TO postgres;

--
-- TOC entry 415 (class 1259 OID 2457489)
-- Name: acueducto_canal_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.acueducto_canal_a AS
 SELECT acueducto_canal_a.gid,
    acueducto_canal_a.fcode,
    catalogo_objetos.descripcion,
    atc.atc_desc,
    smc.smc_desc,
    acueducto_canal_a.txt,
    (acueducto_canal_a.the_geom)::public.geometry(MultiPolygon,32718) AS the_geom
   FROM (((ho_aguas_interiores.acueducto_canal_a
     JOIN catalogo_objetos.catalogo_objetos ON (((acueducto_canal_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.atc ON ((acueducto_canal_a.atc = atc.atc)))
     JOIN catalogo_objetos.smc ON ((acueducto_canal_a.smc = smc.smc)));


ALTER TABLE visualizacion.acueducto_canal_a OWNER TO postgres;

--
-- TOC entry 416 (class 1259 OID 2457494)
-- Name: aeropuerto_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.aeropuerto_a AS
 SELECT aeropuerto_a.gid,
    aeropuerto_a.fcode,
    catalogo_objetos.descripcion,
    aeropuerto_a.nam,
    acc.acc_desc,
    aeropuerto_a.iko,
    fuc.fuc_desc,
    aeropuerto_a.txt,
    (aeropuerto_a.the_geom)::public.geometry(MultiPolygon,32718) AS the_geom
   FROM (((a_aeropuerto_superficie.aeropuerto_a
     JOIN catalogo_objetos.catalogo_objetos ON (((aeropuerto_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((aeropuerto_a.acc = acc.acc)))
     JOIN catalogo_objetos.fuc ON ((aeropuerto_a.fuc = fuc.fuc)));


ALTER TABLE visualizacion.aeropuerto_a OWNER TO postgres;

--
-- TOC entry 417 (class 1259 OID 2457499)
-- Name: bordillo_l; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.bordillo_l AS
 SELECT bordillo_l.gid,
    bordillo_l.fcode,
    catalogo_objetos.descripcion,
    smc.smc_desc,
    bordillo_l.txt,
    (bordillo_l.the_geom)::public.geometry(LineString,32718) AS the_geom
   FROM ((it_asociado_transportacion.bordillo_l
     JOIN catalogo_objetos.catalogo_objetos ON (((bordillo_l.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.smc ON ((bordillo_l.smc = smc.smc)));


ALTER TABLE visualizacion.bordillo_l OWNER TO postgres;

--
-- TOC entry 418 (class 1259 OID 2457504)
-- Name: cancha_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.cancha_a AS
 SELECT cancha_a.gid,
    cancha_a.fcode,
    catalogo_objetos.descripcion,
    cancha_a.nam,
    smc.smc_desc,
    kos.kos_desc,
    cancha_a.txt,
    (cancha_a.the_geom)::public.geometry(MultiPolygon,32718) AS the_geom
   FROM (((gs_recreacion.cancha_a
     JOIN catalogo_objetos.catalogo_objetos ON (((cancha_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.smc ON ((cancha_a.smc = smc.smc)))
     JOIN catalogo_objetos.kos ON ((cancha_a.kos = kos.kos)));


ALTER TABLE visualizacion.cancha_a OWNER TO postgres;

--
-- TOC entry 419 (class 1259 OID 2457509)
-- Name: cementerio_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.cementerio_a AS
 SELECT cementerio_a.gid,
    cementerio_a.fcode,
    catalogo_objetos.descripcion,
    cementerio_a.nam,
    rel.rel_desc,
    cementerio_a.txt,
    (cementerio_a.the_geom)::public.geometry(MultiPolygon,32718) AS the_geom
   FROM ((gs_asociado_poblados.cementerio_a
     JOIN catalogo_objetos.catalogo_objetos ON (((cementerio_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.rel ON ((cementerio_a.rel = rel.rel)));


ALTER TABLE visualizacion.cementerio_a OWNER TO postgres;

--
-- TOC entry 420 (class 1259 OID 2457514)
-- Name: cerca_l; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.cerca_l AS
 SELECT cerca_l.gid,
    cerca_l.fcode,
    catalogo_objetos.descripcion,
    fti.fti_desc,
    wti.wti_desc,
    cerca_l.txt,
    (cerca_l.the_geom)::public.geometry(LineString,32718) AS the_geom
   FROM (((gs_asociado_poblados.cerca_l
     JOIN catalogo_objetos.catalogo_objetos ON (((cerca_l.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.fti ON ((cerca_l.fti = fti.fti)))
     JOIN catalogo_objetos.wti ON ((cerca_l.wti = wti.wti)));


ALTER TABLE visualizacion.cerca_l OWNER TO postgres;

--
-- TOC entry 421 (class 1259 OID 2457519)
-- Name: cuneta_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.cuneta_a AS
 SELECT cuneta_a.gid,
    cuneta_a.fcode,
    catalogo_objetos.descripcion,
    smc.smc_desc,
    cuneta_a.txt,
    cuneta_a.the_geom
   FROM ((it_asociado_transportacion.cuneta_a
     JOIN catalogo_objetos.catalogo_objetos ON (((cuneta_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.smc ON ((cuneta_a.smc = smc.smc)));


ALTER TABLE visualizacion.cuneta_a OWNER TO postgres;

--
-- TOC entry 422 (class 1259 OID 2457523)
-- Name: edificio_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.edificio_a AS
 SELECT edificio_a.gid,
    edificio_a.fcode,
    catalogo_objetos.descripcion,
    edificio_a.nam,
    acc.acc_desc,
    uuc.uuc_desc,
    edificio_a.txt,
    (edificio_a.the_geom)::public.geometry(MultiPolygon,32718) AS the_geom
   FROM (((gs_construcciones.edificio_a
     JOIN catalogo_objetos.catalogo_objetos ON (((edificio_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((edificio_a.acc = acc.acc)))
     JOIN catalogo_objetos.uuc ON ((edificio_a.uuc = uuc.uuc)));


ALTER TABLE visualizacion.edificio_a OWNER TO postgres;

--
-- TOC entry 423 (class 1259 OID 2457528)
-- Name: escalinata_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.escalinata_a AS
 SELECT escalinata_a.gid,
    escalinata_a.fcode,
    catalogo_objetos.descripcion,
    smc.smc_desc,
    escalinata_a.txt,
    (escalinata_a.the_geom)::public.geometry(MultiPolygon,32718) AS the_geom
   FROM ((gs_asociado_poblados.escalinata_a
     JOIN catalogo_objetos.catalogo_objetos ON (((escalinata_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.smc ON ((escalinata_a.smc = smc.smc)));


ALTER TABLE visualizacion.escalinata_a OWNER TO postgres;

--
-- TOC entry 424 (class 1259 OID 2457533)
-- Name: estadio_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.estadio_a AS
 SELECT estadio_a.gid,
    estadio_a.fcode,
    catalogo_objetos.descripcion,
    estadio_a.nam,
    acc.acc_desc,
    estadio_a.txt,
    (estadio_a.the_geom)::public.geometry(MultiPolygon,32718) AS the_geom
   FROM ((gs_recreacion.estadio_a
     JOIN catalogo_objetos.catalogo_objetos ON (((estadio_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((estadio_a.acc = acc.acc)));


ALTER TABLE visualizacion.estadio_a OWNER TO postgres;

--
-- TOC entry 425 (class 1259 OID 2457538)
-- Name: ferrocarril_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.ferrocarril_a AS
 SELECT ferrocarril_a.gid,
    ferrocarril_a.fcode,
    catalogo_objetos.descripcion,
    ferrocarril_a.nam,
    acc.acc_desc,
    fco.fco_desc,
    loc.loc_desc,
    ferrocarril_a.ltn,
    rgc.rgc_desc,
    rra.rra_desc,
    rrc.rrc_desc,
    ferrocarril_a.txt,
    ferrocarril_a.the_geom
   FROM (((((((it_ferrocarriles.ferrocarril_a
     JOIN catalogo_objetos.catalogo_objetos ON (((ferrocarril_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((ferrocarril_a.acc = acc.acc)))
     JOIN catalogo_objetos.fco ON ((ferrocarril_a.fco = fco.fco)))
     JOIN catalogo_objetos.loc ON ((ferrocarril_a.loc = loc.loc)))
     JOIN catalogo_objetos.rgc ON ((ferrocarril_a.rgc = rgc.rgc)))
     JOIN catalogo_objetos.rra ON ((ferrocarril_a.rra = rra.rra)))
     JOIN catalogo_objetos.rrc ON ((ferrocarril_a.rrc = rrc.rrc)));


ALTER TABLE visualizacion.ferrocarril_a OWNER TO postgres;

--
-- TOC entry 426 (class 1259 OID 2457543)
-- Name: gasolinera_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.gasolinera_a AS
 SELECT gasolinera_a.gid,
    gasolinera_a.fcode,
    catalogo_objetos.descripcion,
    gasolinera_a.nam,
    gasolinera_a.txt,
    (gasolinera_a.the_geom)::public.geometry(MultiPolygon,32718) AS the_geom
   FROM (it_transporte_terrestre.gasolinera_a
     JOIN catalogo_objetos.catalogo_objetos ON (((gasolinera_a.fcode)::text = (catalogo_objetos.fcode)::text)));


ALTER TABLE visualizacion.gasolinera_a OWNER TO postgres;

--
-- TOC entry 427 (class 1259 OID 2457547)
-- Name: granja_acuatica_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.granja_acuatica_a AS
 SELECT granja_acuatica_a.gid,
    granja_acuatica_a.fcode,
    catalogo_objetos.descripcion,
    granja_acuatica_a.txt,
    (granja_acuatica_a.the_geom)::public.geometry(MultiPolygon,32718) AS the_geom
   FROM (ho_regulacion_zonas_restringidas.granja_acuatica_a
     JOIN catalogo_objetos.catalogo_objetos ON (((granja_acuatica_a.fcode)::text = (catalogo_objetos.fcode)::text)));


ALTER TABLE visualizacion.granja_acuatica_a OWNER TO postgres;

--
-- TOC entry 428 (class 1259 OID 2457551)
-- Name: intercambiador_vial_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.intercambiador_vial_a AS
 SELECT intercambiador_vial_a.gid,
    intercambiador_vial_a.fcode,
    catalogo_objetos.descripcion,
    intercambiador_vial_a.nam,
    hct.hct_desc,
    rst.rst_desc,
    loc.loc_desc,
    intercambiador_vial_a.txt,
    (intercambiador_vial_a.the_geom)::public.geometry(MultiPolygon,32718) AS the_geom
   FROM ((((it_transporte_terrestre.intercambiador_vial_a
     JOIN catalogo_objetos.catalogo_objetos ON (((intercambiador_vial_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.hct ON ((intercambiador_vial_a.hct = hct.hct)))
     JOIN catalogo_objetos.rst ON ((intercambiador_vial_a.rst = rst.rst)))
     JOIN catalogo_objetos.loc ON ((intercambiador_vial_a.loc = loc.loc)));


ALTER TABLE visualizacion.intercambiador_vial_a OWNER TO postgres;

--
-- TOC entry 429 (class 1259 OID 2457556)
-- Name: invernadero_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.invernadero_a AS
 SELECT invernadero_a.gid,
    invernadero_a.fcode,
    catalogo_objetos.descripcion,
    invernadero_a.nam,
    invernadero_a.txt,
    (invernadero_a.the_geom)::public.geometry(MultiPolygon,32718) AS the_geom
   FROM (ii_agropecuaria.invernadero_a
     JOIN catalogo_objetos.catalogo_objetos ON (((invernadero_a.fcode)::text = (catalogo_objetos.fcode)::text)));


ALTER TABLE visualizacion.invernadero_a OWNER TO postgres;

--
-- TOC entry 430 (class 1259 OID 2457560)
-- Name: isla_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.isla_a AS
 SELECT isla_a.gid,
    isla_a.fcode,
    catalogo_objetos.descripcion,
    isla_a.nam,
    isla_a.na2,
    isla_a.txt,
    (isla_a.the_geom)::public.geometry(MultiPolygon,32718) AS the_geom
   FROM (ho_zonas_costeras.isla_a
     JOIN catalogo_objetos.catalogo_objetos ON (((isla_a.fcode)::text = (catalogo_objetos.fcode)::text)));


ALTER TABLE visualizacion.isla_a OWNER TO postgres;

--
-- TOC entry 431 (class 1259 OID 2457564)
-- Name: lago_laguna_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.lago_laguna_a AS
 SELECT lago_laguna_a.gid,
    lago_laguna_a.fcode,
    catalogo_objetos.descripcion,
    lago_laguna_a.nam,
    lago_laguna_a.na2,
    hyp.hyp_desc,
    lago_laguna_a.txt,
    (lago_laguna_a.the_geom)::public.geometry(MultiPolygon,32718) AS the_geom
   FROM ((ho_aguas_interiores.lago_laguna_a
     JOIN catalogo_objetos.catalogo_objetos ON (((lago_laguna_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.hyp ON ((lago_laguna_a.hyp = hyp.hyp)));


ALTER TABLE visualizacion.lago_laguna_a OWNER TO postgres;

--
-- TOC entry 432 (class 1259 OID 2457569)
-- Name: muro_l; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.muro_l AS
 SELECT muro_l.gid,
    muro_l.fcode,
    catalogo_objetos.descripcion,
    wti.wti_desc,
    muro_l.txt,
    (muro_l.the_geom)::public.geometry(LineString,32718) AS the_geom
   FROM ((gs_asociado_poblados.muro_l
     JOIN catalogo_objetos.catalogo_objetos ON (((muro_l.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.wti ON ((muro_l.wti = wti.wti)));


ALTER TABLE visualizacion.muro_l OWNER TO postgres;

--
-- TOC entry 433 (class 1259 OID 2457574)
-- Name: orilla_l; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.orilla_l AS
 SELECT orilla_l.gid,
    orilla_l.fcode,
    catalogo_objetos.descripcion,
    acc.acc_desc,
    slt.slt_desc,
    orilla_l.txt,
    (orilla_l.the_geom)::public.geometry(LineString,32718) AS the_geom
   FROM (((ho_zonas_costeras.orilla_l
     JOIN catalogo_objetos.catalogo_objetos ON (((orilla_l.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((orilla_l.acc = acc.acc)))
     JOIN catalogo_objetos.slt ON ((orilla_l.slt = slt.slt)));


ALTER TABLE visualizacion.orilla_l OWNER TO postgres;

--
-- TOC entry 434 (class 1259 OID 2457579)
-- Name: parque_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.parque_a AS
 SELECT parque_a.gid,
    parque_a.fcode,
    catalogo_objetos.descripcion,
    parque_a.nam,
    fuc.fuc_desc,
    parque_a.txt,
    (parque_a.the_geom)::public.geometry(MultiPolygon,32718) AS the_geom
   FROM ((gs_recreacion.parque_a
     JOIN catalogo_objetos.catalogo_objetos ON (((parque_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.fuc ON ((parque_a.fuc = fuc.fuc)));


ALTER TABLE visualizacion.parque_a OWNER TO postgres;

--
-- TOC entry 435 (class 1259 OID 2457584)
-- Name: parqueadero_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.parqueadero_a AS
 SELECT parqueadero_a.gid,
    parqueadero_a.fcode,
    catalogo_objetos.descripcion,
    parqueadero_a.nam,
    smc.smc_desc,
    parqueadero_a.txt,
    (parqueadero_a.the_geom)::public.geometry(MultiPolygon,32718) AS the_geom
   FROM ((it_asociado_transportacion.parqueadero_a
     JOIN catalogo_objetos.catalogo_objetos ON (((parqueadero_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.smc ON ((parqueadero_a.smc = smc.smc)));


ALTER TABLE visualizacion.parqueadero_a OWNER TO postgres;

--
-- TOC entry 436 (class 1259 OID 2457589)
-- Name: paseo_peatonal_ciclovia_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.paseo_peatonal_ciclovia_a AS
 SELECT paseo_peatonal_ciclovia_a.gid,
    paseo_peatonal_ciclovia_a.fcode,
    catalogo_objetos.descripcion,
    paseo_peatonal_ciclovia_a.nam,
    smc.smc_desc,
    paseo_peatonal_ciclovia_a.txt,
    (paseo_peatonal_ciclovia_a.the_geom)::public.geometry(MultiPolygon,32718) AS the_geom
   FROM ((it_asociado_transportacion.paseo_peatonal_ciclovia_a
     JOIN catalogo_objetos.catalogo_objetos ON (((paseo_peatonal_ciclovia_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.smc ON ((paseo_peatonal_ciclovia_a.smc = smc.smc)));


ALTER TABLE visualizacion.paseo_peatonal_ciclovia_a OWNER TO postgres;

--
-- TOC entry 437 (class 1259 OID 2457594)
-- Name: piscina_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.piscina_a AS
 SELECT piscina_a.gid,
    piscina_a.fcode,
    catalogo_objetos.descripcion,
    piscina_a.nam,
    piscina_a.txt,
    (piscina_a.the_geom)::public.geometry(MultiPolygon,32718) AS the_geom
   FROM (gs_recreacion.piscina_a
     JOIN catalogo_objetos.catalogo_objetos ON (((piscina_a.fcode)::text = (catalogo_objetos.fcode)::text)));


ALTER TABLE visualizacion.piscina_a OWNER TO postgres;

--
-- TOC entry 438 (class 1259 OID 2457598)
-- Name: plaza_publica_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.plaza_publica_a AS
 SELECT plaza_publica_a.gid,
    plaza_publica_a.fcode,
    catalogo_objetos.descripcion,
    plaza_publica_a.nam,
    smc.smc_desc,
    plaza_publica_a.txt,
    (plaza_publica_a.the_geom)::public.geometry(MultiPolygon,32718) AS the_geom
   FROM ((gs_asociado_poblados.plaza_publica_a
     JOIN catalogo_objetos.catalogo_objetos ON (((plaza_publica_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.smc ON ((plaza_publica_a.smc = smc.smc)));


ALTER TABLE visualizacion.plaza_publica_a OWNER TO postgres;

--
-- TOC entry 439 (class 1259 OID 2457603)
-- Name: plaza_toros_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.plaza_toros_a AS
 SELECT plaza_toros_a.gid,
    plaza_toros_a.fcode,
    catalogo_objetos.descripcion,
    plaza_toros_a.nam,
    plaza_toros_a.txt,
    (plaza_toros_a.the_geom)::public.geometry(MultiPolygon,32718) AS the_geom
   FROM (gs_recreacion.plaza_toros_a
     JOIN catalogo_objetos.catalogo_objetos ON (((plaza_toros_a.fcode)::text = (catalogo_objetos.fcode)::text)));


ALTER TABLE visualizacion.plaza_toros_a OWNER TO postgres;

--
-- TOC entry 440 (class 1259 OID 2457607)
-- Name: puente_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.puente_a AS
 SELECT puente_a.gid,
    puente_a.fcode,
    catalogo_objetos.descripcion,
    puente_a.nam,
    puente_a.na2,
    acc.acc_desc,
    bsc.bsc_desc,
    puente_a.ltn,
    typ.typ_desc,
    tuc.tuc_desc,
    puente_a.txt,
    (puente_a.the_geom)::public.geometry(MultiPolygon,32718) AS the_geom
   FROM (((((it_cruces_enlaces.puente_a
     JOIN catalogo_objetos.catalogo_objetos ON (((puente_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((puente_a.acc = acc.acc)))
     JOIN catalogo_objetos.bsc ON ((puente_a.bsc = bsc.bsc)))
     JOIN catalogo_objetos.typ ON ((puente_a.typ = typ.typ)))
     JOIN catalogo_objetos.tuc ON ((puente_a.tuc = tuc.tuc)));


ALTER TABLE visualizacion.puente_a OWNER TO postgres;

--
-- TOC entry 441 (class 1259 OID 2457612)
-- Name: puerto_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.puerto_a AS
 SELECT puerto_a.gid,
    puerto_a.fcode,
    catalogo_objetos.descripcion,
    puerto_a.nam,
    puerto_a.txt,
    (puerto_a.the_geom)::public.geometry(MultiPolygon,32718) AS the_geom
   FROM (ho_puertos_muelles.puerto_a
     JOIN catalogo_objetos.catalogo_objetos ON (((puerto_a.fcode)::text = (catalogo_objetos.fcode)::text)));


ALTER TABLE visualizacion.puerto_a OWNER TO postgres;

--
-- TOC entry 442 (class 1259 OID 2457616)
-- Name: punto_control_p; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.punto_control_p AS
 SELECT punto_control_p.gid,
    punto_control_p.fcode,
    catalogo_objetos.descripcion,
    acc.acc_desc,
    ela.ela_desc,
    punto_control_p.zvh,
    punto_control_p.txt,
    (punto_control_p.the_geom)::public.geometry(Point,32718) AS the_geom
   FROM (((d_linderos_propiedad.punto_control_p
     JOIN catalogo_objetos.catalogo_objetos ON (((punto_control_p.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((punto_control_p.acc = acc.acc)))
     JOIN catalogo_objetos.ela ON ((punto_control_p.ela = ela.ela)));


ALTER TABLE visualizacion.punto_control_p OWNER TO postgres;

--
-- TOC entry 443 (class 1259 OID 2457621)
-- Name: rio_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.rio_a AS
 SELECT rio_a.gid,
    rio_a.fcode,
    catalogo_objetos.descripcion,
    rio_a.nam,
    rio_a.na2,
    acc.acc_desc,
    hyp.hyp_desc,
    rio_a.txt,
    (rio_a.the_geom)::public.geometry(MultiPolygon,32718) AS the_geom
   FROM (((catalogo_objetos.catalogo_objetos
     JOIN ho_aguas_interiores.rio_a ON (((catalogo_objetos.fcode)::text = (rio_a.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((rio_a.acc = acc.acc)))
     JOIN catalogo_objetos.hyp ON ((rio_a.hyp = hyp.hyp)));


ALTER TABLE visualizacion.rio_a OWNER TO postgres;

--
-- TOC entry 444 (class 1259 OID 2457626)
-- Name: rio_l; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.rio_l AS
 SELECT rio_l.gid,
    rio_l.fcode,
    catalogo_objetos.descripcion,
    rio_l.nam,
    rio_l.na2,
    acc.acc_desc,
    hyp.hyp_desc,
    rio_l.txt,
    (rio_l.the_geom)::public.geometry(LineString,32718) AS the_geom
   FROM (((catalogo_objetos.catalogo_objetos
     JOIN ho_aguas_interiores.rio_l ON (((catalogo_objetos.fcode)::text = (rio_l.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((rio_l.acc = acc.acc)))
     JOIN catalogo_objetos.hyp ON ((rio_l.hyp = hyp.hyp)));


ALTER TABLE visualizacion.rio_l OWNER TO postgres;

--
-- TOC entry 445 (class 1259 OID 2457631)
-- Name: rodera_l; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.rodera_l AS
 SELECT rodera_l.gid,
    rodera_l.fcode,
    catalogo_objetos.descripcion,
    typ.typ_desc,
    rst.rst_desc,
    hct.hct_desc,
    rdt.rdt_desc,
    wtc.wtc_desc,
    rodera_l.ltn,
    tuc.tuc_desc,
    rodera_l.txt,
    (rodera_l.the_geom)::public.geometry(LineString,32718) AS the_geom
   FROM (((((((it_transporte_terrestre.rodera_l
     JOIN catalogo_objetos.catalogo_objetos ON (((rodera_l.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.typ ON ((rodera_l.typ = typ.typ)))
     JOIN catalogo_objetos.hct ON ((rodera_l.hct = hct.hct)))
     JOIN catalogo_objetos.rst ON ((rodera_l.rst = rst.rst)))
     JOIN catalogo_objetos.rdt ON ((rodera_l.rdt = rdt.rdt)))
     JOIN catalogo_objetos.wtc ON ((rodera_l.wtc = wtc.wtc)))
     JOIN catalogo_objetos.tuc ON ((rodera_l.tuc = tuc.tuc)));


ALTER TABLE visualizacion.rodera_l OWNER TO postgres;

--
-- TOC entry 446 (class 1259 OID 2457636)
-- Name: sendero_l; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.sendero_l AS
 SELECT sendero_l.gid,
    sendero_l.fcode,
    catalogo_objetos.descripcion,
    wtc.wtc_desc,
    sendero_l.txt,
    (sendero_l.the_geom)::public.geometry(LineString,32718) AS the_geom
   FROM ((it_transporte_terrestre.sendero_l
     JOIN catalogo_objetos.catalogo_objetos ON (((sendero_l.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.wtc ON ((sendero_l.wtc = wtc.wtc)));


ALTER TABLE visualizacion.sendero_l OWNER TO postgres;

--
-- TOC entry 447 (class 1259 OID 2457641)
-- Name: tunel_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.tunel_a AS
 SELECT tunel_a.gid,
    tunel_a.fcode,
    catalogo_objetos.descripcion,
    tunel_a.nam,
    tra.tra_desc,
    tuc.tuc_desc,
    tunel_a.txt,
    tunel_a.the_geom
   FROM (((it_asociado_transportacion.tunel_a
     JOIN catalogo_objetos.catalogo_objetos ON (((tunel_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.tra ON ((tunel_a.tra = tra.tra)))
     JOIN catalogo_objetos.tuc ON ((tunel_a.tuc = tuc.tuc)));


ALTER TABLE visualizacion.tunel_a OWNER TO postgres;

--
-- TOC entry 448 (class 1259 OID 2457646)
-- Name: via_ruta_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.via_ruta_a AS
 SELECT via_ruta_a.gid,
    via_ruta_a.fcode,
    catalogo_objetos.descripcion,
    via_ruta_a.nam,
    via_ruta_a.na2,
    acc.acc_desc,
    rst.rst_desc,
    typ.typ_desc,
    hct.hct_desc,
    loc.loc_desc,
    via_ruta_a.ltn,
    mes.mes_desc,
    rdt.rdt_desc,
    tuc.tuc_desc,
    via_ruta_a.txt,
    (via_ruta_a.the_geom)::public.geometry(MultiPolygon,32718) AS the_geom
   FROM (((((((((it_transporte_terrestre.via_ruta_a
     JOIN catalogo_objetos.catalogo_objetos ON (((via_ruta_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((via_ruta_a.acc = acc.acc)))
     JOIN catalogo_objetos.rst ON ((via_ruta_a.rst = rst.rst)))
     JOIN catalogo_objetos.typ ON ((via_ruta_a.typ = typ.typ)))
     JOIN catalogo_objetos.hct ON ((via_ruta_a.hct = hct.hct)))
     JOIN catalogo_objetos.loc ON ((via_ruta_a.loc = loc.loc)))
     JOIN catalogo_objetos.mes ON ((via_ruta_a.mes = mes.mes)))
     JOIN catalogo_objetos.rdt ON ((via_ruta_a.rdt = rdt.rdt)))
     JOIN catalogo_objetos.tuc ON ((via_ruta_a.tuc = tuc.tuc)));


ALTER TABLE visualizacion.via_ruta_a OWNER TO postgres;

--
-- TOC entry 449 (class 1259 OID 2457651)
-- Name: zanja_l; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.zanja_l AS
 SELECT zanja_l.gid,
    zanja_l.fcode,
    catalogo_objetos.descripcion,
    hyp.hyp_desc,
    zanja_l.txt,
    (zanja_l.the_geom)::public.geometry(LineString,32718) AS the_geom
   FROM ((ho_aguas_interiores.zanja_l
     JOIN catalogo_objetos.catalogo_objetos ON (((zanja_l.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.hyp ON ((zanja_l.hyp = hyp.hyp)));


ALTER TABLE visualizacion.zanja_l OWNER TO postgres;

--
-- TOC entry 6464 (class 2604 OID 2457656)
-- Name: aeropuerto_a gid; Type: DEFAULT; Schema: a_aeropuerto_superficie; Owner: postgres
--

ALTER TABLE ONLY a_aeropuerto_superficie.aeropuerto_a ALTER COLUMN gid SET DEFAULT nextval('a_aeropuerto_superficie.aeropuerto_a_gid_seq'::regclass);


--
-- TOC entry 6470 (class 2604 OID 2457657)
-- Name: catalogo_objetos gid; Type: DEFAULT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.catalogo_objetos ALTER COLUMN gid SET DEFAULT nextval('catalogo_objetos.catalogo_objetos_gid_seq'::regclass);


--
-- TOC entry 6472 (class 2604 OID 2457658)
-- Name: punto_control_p gid; Type: DEFAULT; Schema: d_linderos_propiedad; Owner: postgres
--

ALTER TABLE ONLY d_linderos_propiedad.punto_control_p ALTER COLUMN gid SET DEFAULT nextval('d_linderos_propiedad.vertice_geodesico_p_gid_seq'::regclass);


--
-- TOC entry 6479 (class 2604 OID 2457659)
-- Name: cementerio_a gid; Type: DEFAULT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.cementerio_a ALTER COLUMN gid SET DEFAULT nextval('gs_asociado_poblados.cementerio_a_gid_seq'::regclass);


--
-- TOC entry 6486 (class 2604 OID 2457660)
-- Name: cerca_l gid; Type: DEFAULT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.cerca_l ALTER COLUMN gid SET DEFAULT nextval('gs_asociado_poblados.cerca_l_gid_seq'::regclass);


--
-- TOC entry 6493 (class 2604 OID 2457661)
-- Name: escalinata_a gid; Type: DEFAULT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.escalinata_a ALTER COLUMN gid SET DEFAULT nextval('gs_asociado_poblados.escalinata_a_gid_seq'::regclass);


--
-- TOC entry 6500 (class 2604 OID 2457662)
-- Name: muro_l gid; Type: DEFAULT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.muro_l ALTER COLUMN gid SET DEFAULT nextval('gs_asociado_poblados.muro_l_gid_seq'::regclass);


--
-- TOC entry 6507 (class 2604 OID 2457663)
-- Name: plaza_publica_a gid; Type: DEFAULT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.plaza_publica_a ALTER COLUMN gid SET DEFAULT nextval('gs_asociado_poblados.plaza_publica_a_gid_seq'::regclass);


--
-- TOC entry 6514 (class 2604 OID 2457664)
-- Name: edificio_a gid; Type: DEFAULT; Schema: gs_construcciones; Owner: postgres
--

ALTER TABLE ONLY gs_construcciones.edificio_a ALTER COLUMN gid SET DEFAULT nextval('gs_construcciones.edificio_a_gid_seq'::regclass);


--
-- TOC entry 6521 (class 2604 OID 2457665)
-- Name: cancha_a gid; Type: DEFAULT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.cancha_a ALTER COLUMN gid SET DEFAULT nextval('gs_recreacion.cancha_a_gid_seq'::regclass);


--
-- TOC entry 6528 (class 2604 OID 2457666)
-- Name: estadio_a gid; Type: DEFAULT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.estadio_a ALTER COLUMN gid SET DEFAULT nextval('gs_recreacion.estadio_a_gid_seq'::regclass);


--
-- TOC entry 6535 (class 2604 OID 2457667)
-- Name: parque_a gid; Type: DEFAULT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.parque_a ALTER COLUMN gid SET DEFAULT nextval('gs_recreacion.parque_a_gid_seq'::regclass);


--
-- TOC entry 6542 (class 2604 OID 2457668)
-- Name: piscina_a gid; Type: DEFAULT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.piscina_a ALTER COLUMN gid SET DEFAULT nextval('gs_recreacion.piscina_a_gid_seq'::regclass);


--
-- TOC entry 6549 (class 2604 OID 2457669)
-- Name: plaza_toros_a gid; Type: DEFAULT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.plaza_toros_a ALTER COLUMN gid SET DEFAULT nextval('gs_recreacion.plaza_toros_a_gid_seq'::regclass);


--
-- TOC entry 6556 (class 2604 OID 2457670)
-- Name: acequia_l gid; Type: DEFAULT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acequia_l ALTER COLUMN gid SET DEFAULT nextval('ho_aguas_interiores.acequia_l_gid_seq'::regclass);


--
-- TOC entry 6563 (class 2604 OID 2457671)
-- Name: acueducto_canal_a gid; Type: DEFAULT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acueducto_canal_a ALTER COLUMN gid SET DEFAULT nextval('ho_aguas_interiores.acueducto_canal_a_gid_seq'::regclass);


--
-- TOC entry 6570 (class 2604 OID 2457672)
-- Name: lago_laguna_a gid; Type: DEFAULT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.lago_laguna_a ALTER COLUMN gid SET DEFAULT nextval('ho_aguas_interiores.lago_laguna_a_gid_seq'::regclass);


--
-- TOC entry 6577 (class 2604 OID 2457673)
-- Name: rio_a gid; Type: DEFAULT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.rio_a ALTER COLUMN gid SET DEFAULT nextval('ho_aguas_interiores.rio_a_gid_seq'::regclass);


--
-- TOC entry 6584 (class 2604 OID 2457674)
-- Name: rio_l gid; Type: DEFAULT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.rio_l ALTER COLUMN gid SET DEFAULT nextval('ho_aguas_interiores.rio_l_gid_seq'::regclass);


--
-- TOC entry 6591 (class 2604 OID 2457675)
-- Name: zanja_l gid; Type: DEFAULT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.zanja_l ALTER COLUMN gid SET DEFAULT nextval('ho_aguas_interiores.zanja_l_gid_seq'::regclass);


--
-- TOC entry 6598 (class 2604 OID 2457676)
-- Name: puerto_a gid; Type: DEFAULT; Schema: ho_puertos_muelles; Owner: postgres
--

ALTER TABLE ONLY ho_puertos_muelles.puerto_a ALTER COLUMN gid SET DEFAULT nextval('ho_puertos_muelles.puerto_a_gid_seq'::regclass);


--
-- TOC entry 6605 (class 2604 OID 2457677)
-- Name: granja_acuatica_a gid; Type: DEFAULT; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--

ALTER TABLE ONLY ho_regulacion_zonas_restringidas.granja_acuatica_a ALTER COLUMN gid SET DEFAULT nextval('ho_regulacion_zonas_restringidas.granja_acuatica_a_gid_seq'::regclass);


--
-- TOC entry 6612 (class 2604 OID 2457678)
-- Name: isla_a gid; Type: DEFAULT; Schema: ho_zonas_costeras; Owner: postgres
--

ALTER TABLE ONLY ho_zonas_costeras.isla_a ALTER COLUMN gid SET DEFAULT nextval('ho_zonas_costeras.isla_a_gid_seq'::regclass);


--
-- TOC entry 6619 (class 2604 OID 2457679)
-- Name: orilla_l gid; Type: DEFAULT; Schema: ho_zonas_costeras; Owner: postgres
--

ALTER TABLE ONLY ho_zonas_costeras.orilla_l ALTER COLUMN gid SET DEFAULT nextval('ho_zonas_costeras.orilla_l_gid_seq'::regclass);


--
-- TOC entry 6633 (class 2604 OID 2457680)
-- Name: acera_a gid; Type: DEFAULT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.acera_a ALTER COLUMN gid SET DEFAULT nextval('it_asociado_transportacion.acera_a_gid_seq'::regclass);


--
-- TOC entry 6640 (class 2604 OID 2457681)
-- Name: bordillo_l gid; Type: DEFAULT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.bordillo_l ALTER COLUMN gid SET DEFAULT nextval('it_asociado_transportacion.bordillo_l_gid_seq'::regclass);


--
-- TOC entry 6647 (class 2604 OID 2457682)
-- Name: cuneta_a gid; Type: DEFAULT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.cuneta_a ALTER COLUMN gid SET DEFAULT nextval('it_asociado_transportacion.cuneta_a_gid_seq'::regclass);


--
-- TOC entry 6654 (class 2604 OID 2457683)
-- Name: parqueadero_a gid; Type: DEFAULT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.parqueadero_a ALTER COLUMN gid SET DEFAULT nextval('it_asociado_transportacion.parqueadero_a_gid_seq'::regclass);


--
-- TOC entry 6661 (class 2604 OID 2457684)
-- Name: paseo_peatonal_ciclovia_a gid; Type: DEFAULT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.paseo_peatonal_ciclovia_a ALTER COLUMN gid SET DEFAULT nextval('it_asociado_transportacion.paseo_peatonal_ciclovia_a_gid_seq'::regclass);


--
-- TOC entry 6668 (class 2604 OID 2457685)
-- Name: tunel_a gid; Type: DEFAULT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.tunel_a ALTER COLUMN gid SET DEFAULT nextval('it_asociado_transportacion.tunel_a_gid_seq'::regclass);


--
-- TOC entry 6675 (class 2604 OID 2457686)
-- Name: puente_a gid; Type: DEFAULT; Schema: it_cruces_enlaces; Owner: postgres
--

ALTER TABLE ONLY it_cruces_enlaces.puente_a ALTER COLUMN gid SET DEFAULT nextval('it_cruces_enlaces.puente_a_gid_seq'::regclass);


--
-- TOC entry 6682 (class 2604 OID 2457687)
-- Name: ferrocarril_a gid; Type: DEFAULT; Schema: it_ferrocarriles; Owner: postgres
--

ALTER TABLE ONLY it_ferrocarriles.ferrocarril_a ALTER COLUMN gid SET DEFAULT nextval('it_ferrocarriles.ferrocarril_a_gid_seq'::regclass);


--
-- TOC entry 6689 (class 2604 OID 2457688)
-- Name: gasolinera_a gid; Type: DEFAULT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.gasolinera_a ALTER COLUMN gid SET DEFAULT nextval('it_transporte_terrestre.gasolinera_a_gid_seq'::regclass);


--
-- TOC entry 6696 (class 2604 OID 2457689)
-- Name: intercambiador_vial_a gid; Type: DEFAULT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.intercambiador_vial_a ALTER COLUMN gid SET DEFAULT nextval('it_transporte_terrestre.intercambiador_vial_a_gid_seq'::regclass);


--
-- TOC entry 6703 (class 2604 OID 2457690)
-- Name: rodera_l gid; Type: DEFAULT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.rodera_l ALTER COLUMN gid SET DEFAULT nextval('it_transporte_terrestre.rodera_l_gid_seq'::regclass);


--
-- TOC entry 6710 (class 2604 OID 2457691)
-- Name: sendero_l gid; Type: DEFAULT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.sendero_l ALTER COLUMN gid SET DEFAULT nextval('it_transporte_terrestre.sendero_l_gid_seq'::regclass);


--
-- TOC entry 6717 (class 2604 OID 2457692)
-- Name: via_ruta_a gid; Type: DEFAULT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a ALTER COLUMN gid SET DEFAULT nextval('it_transporte_terrestre.via_ruta_a_gid_seq'::regclass);


--
-- TOC entry 7334 (class 0 OID 2456944)
-- Dependencies: 309
-- Data for Name: aeropuerto_a; Type: TABLE DATA; Schema: a_aeropuerto_superficie; Owner: postgres
--



--
-- TOC entry 7336 (class 0 OID 2456956)
-- Dependencies: 311
-- Data for Name: acc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.acc VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.acc VALUES (1, '1.- Exacta');
INSERT INTO catalogo_objetos.acc VALUES (2, '2.- Aproximada');
INSERT INTO catalogo_objetos.acc VALUES (3, '3.- Dudosa');
INSERT INTO catalogo_objetos.acc VALUES (7, '7.- Precisa');
INSERT INTO catalogo_objetos.acc VALUES (998, '998.- No aplica');


--
-- TOC entry 7337 (class 0 OID 2456959)
-- Dependencies: 312
-- Data for Name: atc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.atc VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.atc VALUES (1, '1.- Pozo Qanat');
INSERT INTO catalogo_objetos.atc VALUES (3, '3.- Acueducto subterráneo');
INSERT INTO catalogo_objetos.atc VALUES (4, '4.- Bajo el agua');
INSERT INTO catalogo_objetos.atc VALUES (5, '5.- Superficie');
INSERT INTO catalogo_objetos.atc VALUES (998, '998.- No aplica');


--
-- TOC entry 7338 (class 0 OID 2456962)
-- Dependencies: 313
-- Data for Name: bsc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.bsc VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.bsc VALUES (1, '1.- Arco abierto Spandrel');
INSERT INTO catalogo_objetos.bsc VALUES (2, '2.- Voladizo');
INSERT INTO catalogo_objetos.bsc VALUES (3, '3.- Cubierta');
INSERT INTO catalogo_objetos.bsc VALUES (5, '5.- Flotante');
INSERT INTO catalogo_objetos.bsc VALUES (6, '6.- De viga');
INSERT INTO catalogo_objetos.bsc VALUES (7, '7.- Torre de suspensión');
INSERT INTO catalogo_objetos.bsc VALUES (8, '8.- Entramado');
INSERT INTO catalogo_objetos.bsc VALUES (9, '9.- Suspensión');
INSERT INTO catalogo_objetos.bsc VALUES (12, '12.- Transportador');
INSERT INTO catalogo_objetos.bsc VALUES (15, '15.- De losa');
INSERT INTO catalogo_objetos.bsc VALUES (16, '16.- Viga y largero');
INSERT INTO catalogo_objetos.bsc VALUES (19, '19.- Cuerda del arco del puente');
INSERT INTO catalogo_objetos.bsc VALUES (22, '22.- Cubierto');
INSERT INTO catalogo_objetos.bsc VALUES (26, '26.- Arco cerrado spandrel');
INSERT INTO catalogo_objetos.bsc VALUES (27, '27.- Atirantado');
INSERT INTO catalogo_objetos.bsc VALUES (28, '28.- Viaducto');
INSERT INTO catalogo_objetos.bsc VALUES (31, '31.- Arco');
INSERT INTO catalogo_objetos.bsc VALUES (32, '32.- Caballete');
INSERT INTO catalogo_objetos.bsc VALUES (998, '998.- No aplica');


--
-- TOC entry 7339 (class 0 OID 2456965)
-- Dependencies: 314
-- Data for Name: catalogo_objetos; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AA051', 'Boca de Pozo', 'Equipo utilizado para mantener el control de un pozo, incluyen accesorios como válvulas.', 1);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AA052', 'Campo de Petróleo/Gas', 'Área donde se ha identificado la presencia de petróleo, aceite y/o gas natural.', 2);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AA012', 'Cantera', 'Explotación generalmente a cielo abierto de la que se obtienen rocas industriales, ornamentales y otros materiales usados en la construcción.', 3);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AA010', 'Mina', 'Excavación hecha en la tierra para la extracción de materiales de depósitos naturales.', 4);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AA050', 'Pozo', 'Excavación o perforación hecha en la tierra o mar para la extracción de líquidos o gases.', 5);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AA040', 'Torre de Perforación', 'Superestructura equipada para la perforación o el levantamiento de las operaciones de extracción y / o explotación de recursos naturales.', 6);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BB241', 'Astillero', 'Área  al lado del mar o un río importante, que incluye  instalaciones en las que los buques se construyen o reparan.', 7);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AC040', 'Instalación Petrolera', 'Área con instalaciones para la producción o distribución de petróleo, aceite y/o productos de gas natural.', 8);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AC000', 'Planta de Procesamiento', 'Instalación que incluye uno o más edificios utilizados para procesar materiales.', 9);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH220', 'Planta de Tratamiento de Agua', 'Instalaciones para el almacenamiento, purificación y suministro del agua para un área o una ciudad.', 10);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AE010', 'Planta Ensambladora', 'Edificio o grupo de edificios dedicados a combinar piezas fabricadas para obtener un producto terminado.', 11);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AC030', 'Tanque de Decantación', 'Sitio donde la materia sólida se precipita de un líquido mediante sedimentación.', 12);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH175', 'Abrevadero', 'Contenedor abierto de retención de agua para dar de beber a los animales.', 13);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AJ030', 'Corral', 'Lugar cerrado en el cual el ganado es custodiado temporalmente.', 14);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AJ080', 'Establo', 'Lugar cubierto adaptado para el refugio y alimentación del ganado y las aves.', 15);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AJ060', 'Hacienda', 'Lugar que puede ser de cualquier tamaño desde unas pocas hectáreas a miles de hectáreas, y puede estar especializada en una particular forma de producción de alimento y/o ganado.', 16);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AJ070', 'Rancho', 'Extensión de tierra, incluye las estructuras, cuyo principal uso es el pastoreo de ganado en general, puede presentar también cultivos.', 17);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH240', 'Sistema de Irrigación', 'Sistema para proveer de agua a la tierra, generalmente a través de una red de canales o tuberías.', 18);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AD010', 'Central Eléctrica', 'Edificio y equipamiento necesario para la generación de energía eléctrica.', 19);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AT030', 'Línea de Transmisión Eléctrica', 'Cable que transmite o distribuye energía eléctrica.', 20);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AD030', 'Subestación Eléctrica', 'Infraestructura localizada sobre la ruta de la línea de energía eléctrica en la cual se transforma  y/o se distribuye la energía.', 21);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AT010', 'Antena Parabólica', 'Objeto cóncavo utilizado para la transmisión o recepción de señales electromagnéticas.', 22);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AT060', 'Línea Telefónica', 'Sistema de comunicación que transmite señales eléctricas con información a distancias muy largas.', 23);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AT080', 'Torre de Comunicación', 'Estructura relativamente alta utilizada para transmitir, y/o recibir señales de comunicación electromagnéticas.', 24);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AF010', 'Chimenea', 'Estructura vertical que contiene un tubo o cañón para descarga de humo o gases de combustión.', 25);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AF070', 'Mechero', 'Tubería abierta en la cual los gases residuales son quemados.', 26);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AF030', 'Torre de Enfriamiento', 'Torre utilizada para enfriar líquidos.', 27);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ113', 'Tubería', 'Serie de tubos conectados para el transporte de sólidos, líquidos o gases.', 28);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AM010', 'Bodega', 'Área utilizada para almacenamiento de productos o suministros.', 29);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AM040', 'Pila Mineral', 'Montículo de productos mineros o de cantera, extraídos por el hombre, que no contienen materiales de desecho.', 30);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AM091', 'Silo', 'Contenedor cilíndrico cerrado, utilizado para guardar el grano o forraje.', 31);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AM070', 'Tanque de Almacenamiento', 'Depósito usado para el almacenamiento de líquidos y/o gases.', 32);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AM080', 'Torre de Agua', 'Torre que sirve de apoyo a un tanque elevado de almacenamiento de agua.', 33);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AB021', 'Difusor/Colector', 'Instalación artificial, generalmente subterránea donde los líquidos son evacuados.', 34);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AB030', 'Instalación para Procesamiento de Residuos', 'Sitio funcional con edificios y otras instalaciones, donde los residuos son procesados a través de  procedimientos químicos, físicos, biológicos o térmicos, o combinaciones de estos.', 35);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AB000', 'Vertedero/Basurero', 'Área para la recolección o depósito de materiales de desecho o descarga.', 36);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL135', 'Comunidad', 'Concentración de viviendas nativas, generalmente chozas, usualmente de construcción tradicional.', 37);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL015', 'Edificio', 'Estructura techada relativamente permanente, diseñada para algún uso particular.', 38);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL105', 'Poblado', 'Concentración continua ocupada de tiendas  o ligeras estructuras fijas (por ejemplo: chozas) que sirven como residencia.', 39);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL020', 'Zona Edificada', 'Área que contiene concentración de construcciones y/u otras estructuras.', 40);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL030', 'Cementerio', 'Sitio de estructuras asociadas, utilizadas para el entierro de muertos.', 41);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL070', 'Cerca', 'Barrera artificial construida por el hombre de estructura relativamente liviana utilizada como cercado o límite.', 42);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL099', 'Choza', 'Construcción rústica, pequeña, sencilla e independiente que por lo general tiene una sola habitación individual multifunción.', 43);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ150', 'Escalinata', 'Serie de escalones que sirven para subir a un plano más elevado o para bajar a un plano inferior.', 44);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL130', 'Monumento', 'Estructura levantada o mantenida en memoria a una persona o evento.', 45);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL260', 'Muro', 'Barrera hecha por el hombre de material resistente utilizado como límite o para protección.', 46);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL170', 'Plaza Pública', 'Sitio abierto y que sirve como lugar de reunión pública en una zona poblada para diversos usos.', 47);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH230', 'Pozo de Agua', 'Excavación o perforación hecha en la tierra para la extracción de agua.', 48);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL241', 'Torre', 'Estructura relativamente alta,  que puede presentarse sola o puede formar parte de otra estructura.', 49);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL240', 'Torre que no es para Comunicación', 'Torre  que se utiliza para fines distintos de la comunicación.', 50);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AG030', 'Complejo Comercial', 'Instalaciones comerciales de varios  almacenes, con restaurantes, lugares de entretenimiento y  otras empresas,  está completamente cubierto y cuenta con una amplia zona de estacionamiento.', 51);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BA011', 'Línea de Costa', 'Línea generada por el contacto entre la tierra y un cuerpo de agua afectado por mareas y definida por el nivel de la pleamar media.', 98);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL014', 'Estructura no Construida', 'Construcción económicamente independiente,  diseñada para apoyar las actividades humanas (por ejemplo:  agricultura,  industria o minería), pero no destinados a la ocupación humana y/o habitación.', 52);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL011', 'Instalación', 'Agrupación de instalaciones, situadas en la misma zona, que apoyan funciones particulares.', 53);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK200', 'Balneario', 'Establecimiento que se levanta cerca de fuentes de aguas mineromedicinales (declaradas de utilidad pública) con la finalidad de utilizar sus propiedades terapéuticas y estéticas.', 54);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK040', 'Cancha', 'Lugar al aire libre destinado a eventos deportivos, ejercicio o juegos.', 55);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK160', 'Coliseo', 'Escenario parcial o totalmente rodeado por una estructura diseñada para permitir a los espectadores de pie o sentados visualizar un evento.  A menudo diseñados en forma y tamaño para dar cabida a deportes específicos (por ejemplo: fútbol, ​​baloncesto, etc.), teatro o actuaciones musicales.', 56);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK165', 'Estadio', 'Campo deportivo parcial o totalmente rodeado por una estructura diseñada para permitir a los espectadores ver un evento de pie o sentados; a menudo diseñados en forma y tamaño para dar cabida a deportes específicos (por ejemplo: el fútbol).', 57);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK121', 'Mirador', 'Área, generalmente en un lugar elevado, con infraestructura para observaciones del paisaje circundante.', 58);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK120', 'Parque', 'Área utilizada con propósitos recreacionales u ornamentales.', 59);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK030', 'Parque de Diversión', 'Instalación predominantemente artificial, equipada con dispositivos recreacionales.', 60);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK190', 'Paseo Marítimo', 'Estructura que se extiende en el agua utilizada con propósitos recreacionales, no pretende ser un lugar de atraque de buques.', 61);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK170', 'Piscina', 'Construcción destinada a contener agua con fines de recreación y natación.', 62);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK130', 'Pista de Carreras', 'Superficie que se utiliza para competencias de carreras.', 63);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK166', 'Plaza de Toros', 'Construcción generalmente circular u ovalada, de cielo abierto, rodeada por graderíos para los espectadores.', 64);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK090', 'Recinto Ferial', 'Área donde existen instalaciones permanentes al aire libre para realizar ferias, circos o exhibiciones.', 65);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL200', 'Ruinas', 'Remanentes deteriorados de estructuras no especificadas.', 66);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL012', 'Sitio Arqueológico', 'Sitio donde se ha descubierto la existencia de restos de civilizaciones ancestrales o actividades humanas.', 67);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL201', 'Sitio Histórico', 'Sitio o área declarada de significado histórico nacional o provincial mantenido para el público.', 68);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK110', 'Tribuna', 'Estructura elevada en vías, centros deportivos, etc. generalmente para la presentación especial de eventos al aire libre.', 69);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK180', 'Zoológico', 'Lugar donde los animales, generalmente salvajes, se mantienen en exposición al público, pueden reproducirse y ser estudiados.', 70);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL142', 'Observatorio Astronómico', 'Edificio diseñado y equipado para realizar observaciones de objetos celestes, del espacio y del universo en su conjunto.', 71);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AN010', 'Ferrocarril', 'Una o más vías de ferrocarril que comprende una red utilizada para el transporte de pasajeros y/o bienes.', 72);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AN070', 'Estación de Ferrocarril', 'Instalación en la que los pasajeros pueden subir y bajar de los trenes y/o cargar  y descargar  mercancías del transporte ferroviario.', 73);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ180', 'Estación de Pesaje', 'Construcción y equipos asociados que se utilizan para examinar y pesar  los vehículos de motor.', 74);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ170', 'Gasolinera', 'Establecimiento en el cual se vende combustible y lubricantes generalmente para vehículos de motor.', 75);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AP020', 'Intercambiador Vial', 'Conexión diseñada para facilitar el acceso del tráfico de una carretera a  otra.', 76);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AP010', 'Rodera', 'Vía natural con poca o ninguna mejora por la que pueden transitar vehículos de doble tracción.', 77);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AP050', 'Sendero', 'Camino angosto abierto por el tránsito de personas o animales.', 78);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AP030', 'Vía o Ruta', 'Trayecto con una superficie especialmente  preparada que se mantiene para ser usada por vehículos generalmente a motor.', 79);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AT041', 'Transporte Aéreo por Cable', 'Sistema de transporte que consiste en cables de carga  unidos entre torres en los que están suspendidas las unidades (por ejemplo: tarabita, teleférico).', 80);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ070', 'Gabarra', 'Ruta definida que cruza una gabarra de una orilla a otra.', 81);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ040', 'Puente', 'Estructura que conecta dos lugares y facilita el paso  de una ruta de  transporte (por ejemplo:carretera o ferrocarril)  sobre un obstáculo del terreno (por ejemplo: cuerpo de agua, barranco y/o carretera).', 82);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ065', 'Alcantarilla', 'Estructura hecha por el hombre que permite el cruce de un cauce de agua bajo una vía u otra infraestructura, así como una construcción destinada a evacuar aguas residuales.', 83);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AP040', 'Control Vehicular', 'Barrera en una ruta de transporte (por ejemplo: una carretera, un ferrocarril, un túnel o un puente) que controla el paso (puede ser abierto o cerrado).', 84);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ036', 'Cuneta', 'Borde de hormigón, asfalto o piedras que forman parte de un canal a lo largo del borde de una calle o carretera.', 85);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ080', 'Estación de Gabarra', 'Lugar donde una gabarra toma o descarga su carga.', 86);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AM510', 'Estación de Transbordo', 'Complejo de edificios, instalaciones asociadas, carreteras y zonas adaptadas, utilizadas para el transbordo de pasajeros y carga entre los mismos o diferentes tipos de transporte.', 87);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ125', 'Estación de Transporte', 'Estación que sirve como un punto de parada a lo largo de una ruta de transporte.', 88);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ140', 'Parqueadero', 'Lugar destinado generalmente para estacionar vehículos.', 89);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AP034', 'Parterre', 'Obra o espacio vial entre dos rutas de transporte para separar el flujo del tráfico (por ejemplo, en sentido contrario).', 90);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AP031', 'Paseo Peatonal / Ciclovía', 'Franja de terreno pavimentada o mejorada que tiene por objeto servir como una vía para  peatones, animales y/o vehículos no motorizado.', 91);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ152', 'Puente Peatonal', 'Estructura elevada o suspendida que permite el  paso de peatones.', 92);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ060', 'Torre de Control', 'Estructura que alberga personas y equipos que cumplen con  la función de controlar el tráfico aéreo, náutico o de trenes.', 93);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ130', 'Túnel', 'Paso subterráneo o submarino, abierto para establecer comunicación.', 94);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH190', 'Albufera', 'Laguna natural que se forma en una bahía o entrada de mar cuya boca ha quedado cerrada por cordones de arena o arrecifes de coral.', 95);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BA023', 'Anteplaya', 'La parte de la costa o playa que se encuentra entre la línea de bajamar y el límite superior de la acción del oleaje normal (arena, grava, arcilla y barro).', 96);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BA030', 'Isla', 'Masa de tierra más pequeña que un continente y rodeada por agua.', 97);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BA040', 'Mar', 'Masa de agua salada que cubre la mayor parte de la superficie de la Tierra.', 99);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BA010', 'Orilla', 'Línea donde una superficie está en contacto con un cuerpo de agua.', 100);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BA050', 'Playa', 'Ribera del mar o de un río grande, formada de arenales en un superficie casi plana.', 101);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BA051', 'Dique', 'Barrera o construcción para contener o detener el agua.', 102);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BI030', 'Esclusa', 'Un par o una serie de compuertas utilizadas para levantar y bajar los barcos a medida que pasan desde el nivel del agua a otra.', 103);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BB043', 'Malecón', 'Murallón que corre paralelo a la orilla del mar o de un río, con la finalidad de proteger de las aguas.', 104);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BB190', 'Muelle', 'Obra construida en un puerto de mar o en la orilla de un río navegable para facilitar las tareas de carga, descarga y para atracar los barcos.', 105);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BB005', 'Puerto', 'Conjunto de obras, instalaciones y servicios que proporcionan el espacio necesario para la estancia de los buques mientras realizan operaciones de carga, descarga, almacenaje y tránsito de viajeros.', 106);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BB041', 'Rompeolas', 'Estructura avanzada hacia el mar que protege un puerto o playa de la acción de las olas.', 107);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BE015', 'Curva Batimétrica', 'Línea que conecta puntos de igual profundidad y por debajo del datum hidrográfico.', 108);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BC020', 'Boya', 'Objeto flotante que se sujeta al fondo del mar, de un lago o de un río, que sirve como ayuda a la navegación.', 109);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BC050', 'Faro', 'Estructura distintiva dentro o fuera de la costa con luz en su parte superior, diseñado para servir como una ayuda a la navegación.', 110);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BD120', 'Arrecife', 'Costa peñascosa, formada en el mar por roca o coral, casi a flor de agua, que constituye peligro para la navegación.', 111);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BD180', 'Naufragio', 'Ruinas de un barco hundido o irreversiblemente dañado.', 112);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BD110', 'Plataforma marina', 'Superficie plana levantada sobre el mar, como etapa de trabajo en la conducción de operaciones mar adentro.', 113);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BD130', 'Roca', 'Formación rocosa aislada, piedra o coral de gran tamaño, que constituye un peligro para la navegación.', 114);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH050', 'Granja Acuática', 'Área cerrada de agua utilizada para la reproducción o cría de camarones, peces y similares.', 115);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH030', 'Acequia', 'Excavación poco profunda construida en tierra con propósitos de drenaje o irrigación.', 116);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH010', 'Acueducto o Canal', 'Cauce artificial que transporta agua en forma de flujo continuo desde un lugar en el que ésta es accesible para consumo u otros usos.', 117);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH090', 'Área de Inundación', 'Área periódicamente cubierta por agua, excluyendo el agua por marea.', 118);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH011', 'Bocatoma', 'Lugar donde el agua es captada en un canal, tubería u otro cuerpo de agua.', 119);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH020', 'Canal de Navegación', 'Canal artificial sin flujo o flujo controlado, construido o usado para navegación.', 120);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH200', 'Característica Miscelánea de Drenaje de Superficie', 'Característica de drenaje de superficie la cual es de naturaleza menor y que no está incluida en otros elementos codificado en estas especificaciones.', 121);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH180', 'Cascada', 'Caída vertical de un curso de agua, producida por brusco desnivel del cauce.', 122);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH015', 'Ciénaga', 'Área permanentemente húmeda de la tierra formada por materia orgánica en descomposición y sobre todo de agua dulce estancada.', 123);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BI010', 'Cisterna', 'Contenedor cubierto, construido por el hombre utilizado para recolectar y almacenar el agua.', 124);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BI040', 'Compuerta', 'Puerta utilizada para regular el flujo de agua.', 125);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH130', 'Embalse', 'Depósito artificial en el que se almacenan las aguas de un río o un arroyo, generalmente mediante una presa o un dique que cierra la boca de un valle.', 126);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ116', 'Estación de Bombeo', 'Instalación para mover sólidos, líquidos o gases a través de presión o succión.', 127);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH081', 'Estanque', 'Depósito construido para recolección o almacenamiento de agua para consumo humano o agropecuario.', 128);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH155', 'Evaporador Salino', 'Piscina poco profunda, normalmente construida por el hombre, en donde se recoge sal por la evaporación natural del agua.', 129);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH080', 'Lago o Laguna', 'Cuerpo de agua, dulce o salada, rodeada por tierra.', 130);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH170', 'Manantial', 'Flujo natural de agua que brota en la superficie de la tierra.', 131);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BI020', 'Presa', 'Estructura generalmente de cemento armado, construida a través de un río, arroyo o canal  para contener o controlar el caudal.', 132);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH145', 'Punto Desvanecido', 'Lugar en el cual la corriente de agua desaparece o se desvanece en el terreno.', 133);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH120', 'Rápidos', 'Partes de un río, donde la corriente fluye con gran rapidez, debido a alteraciones en la superficie provocadas por obstrucciones tale como rocas y peñascos.', 134);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH140', 'Río', 'Curso de agua que fluye naturalmente.', 135);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AJ020', 'Sifón', 'Tubería utilizada para el transporte de líquidos de un nivel  a un nivel inferior, usando la diferencia de presión del líquido para forzar subir a la columna hasta un nivel más alto antes de que caiga a la salida.', 136);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH070', 'Vado', 'Sitio poco profundo en un río o corriente de agua utilizado para cruzar a pie, a caballo o en vehículo.', 137);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH100', 'Zanja', 'Excavación larga y estrecha que se hace en la tierra para echar los cimientos, conducir las aguas, defender los sembríos o usos semejantes.', 138);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('CA010', 'Curva de Nivel', 'Línea que conecta puntos que tienen el mismo valor de altura respecto al datum vertical.', 139);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('CA030', 'Punto Acotado/de Cota', 'Lugar designado con un valor de elevación relativa con respecto a un datum vertical.', 140);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('DB010', 'Acantilado', 'Superficie empinada vertical o dominante de una roca o de la tierra.', 141);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('DB170', 'Duna', 'Uno o varios montículos o lomas de arena por lo general formadas por el viento.', 142);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('DB029', 'Entrada de Cueva', 'Entrada a una serie interconectada de cámaras subterráneas.', 143);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('DB160', 'Estrato Rocoso', 'Importante afloramiento del lecho rocoso expuesto.', 144);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('DB061', 'Grieta', 'Hendidura, fisura, abertura muy fina en la superficie de la tierra, especialmente en la roca.', 145);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BJ099', 'Límite de Nieve', 'Capa permanente de hielo que cubre una extensión de tierra  o  la cima de una montaña.', 146);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('DB090', 'Terraplén', 'Montículo largo de tierra u otro material, realizado por el hombre, que se levanta para hacer una defensa, camino u otra obra semejante.', 147);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('DA010', 'Característica del Suelo', 'Región de la tierra que es homogénea con respecto a una característica del suelo.', 148);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH160', 'Salitral', 'Yacimiento natural cuyo lecho está cubierto con sal  incrustada.', 149);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH150', 'Salina', 'Mina de sal.', 150);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('DB185', 'Cráter', 'Depresión en el terreno en forma cóncava, generalmente redonda y con bordes escarpados.', 151);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL045', 'Objeto Agregado', 'Lugar que no aparece como un objeto específico, pero con cual la información específica es asociada.', 195);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BJ030', 'Glaciar', 'Gran masa o un río de hielo que se forma por acumulación y  compactación de la nieve en  un terreno alto que se mueve  lentamente por una pendiente o valle por encima de la línea de nieve.', 152);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('EC040', 'Desmonte', 'Zona de terreno donde se ha desbrozado la vegetación; para facilitar principalmente: el acceso de una carretera, ferrocarril, tubería, línea de transmisión eléctrica; demarcar una frontera; obtener línea de vista, o para impedir el progreso de los incendios forestales (un cortafuegos).', 153);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('ZD020', 'Zona sin Información', 'Área que carece de fuentes de cobertura adecuada o donde no se requiere información.', 154);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('EA010', 'Cultivo', 'Área que ha sido labrada para plantar diferentes cosechas; se incluyen terrenos con barbecho.', 155);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('EA030', 'Vivero', 'Lugar donde arbustos, flores, plantas y árboles se cultivan para transplante, semilla o injerto.', 156);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('EB020', 'Matorral', 'Zona cubierta principalmente por especies arbustivas no cultivadas, que están densamente enredadas entre sí.', 157);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('EB010', 'Pastizal', 'Vegetación herbácea o pasto que tienen poco o ningún tejido leñoso.', 158);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('EC005', 'Árbol', 'Planta perenne, de tronco leñoso que crece a una altura considerable y se ramifica a cierta distancia del suelo.', 159);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('EC015', 'Bosque', 'Área con alta densidad de árboles, a veces combinada con maleza y pasto.', 160);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('EC060', 'Claro de Bosque', 'Sitio en un bosque que ha sido limpiado, a menudo por la agricultura de corte, quema y/o como resultado de la tala maderera. También puede producirse por causas naturales, tales como un incendio forestal.', 161);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('EE020', 'Tierra sin Vegetación', 'Una zona con cobertura menor al 5 % o sin vegetación.', 162);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('ED030', 'Zona de Manglar', 'Denso matorral de mangle que está sujeto a inundación por mareas y formación de pantanos.', 163);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('ED020', 'Pantano', 'Terreno húmedo y lodoso, con un drenaje muy pobre, tiene cierto tipo de vegetación acuática y  dificulta el tránsito.', 164);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('FA000', 'Límite Administrativo', 'Límite entre zonas controladas administrativamente.', 165);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('FA001', 'Zona Administrativa', 'Área controlada mediante una autoridad administrativa.', 166);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('ZB030', 'Hito', 'Marca que indica un punto físico sobre la superficie de la tierra cuya posición ha sido medida.', 167);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('IA041', 'Manzana', 'Superficie de terreno o agrupación de lotes cuyo conjunto está delimitado por vías de transito y/o accidentes geográficos naturales.', 168);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('ZB060', 'Vértice Geodésico', 'Punto físico sobre la superficie de la tierra que tiene una posición conocida y se estableció como parte de una red geodésica.', 169);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('GB005', 'Aeropuerto', 'Zona provista de un conjunto de pistas, instalaciones y servicios destinados al tráfico regular de aeronaves.', 170);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('GB015', 'Estacionamiento de Aeronaves', 'Área definida, en un aeródromo terrestre/helipuerto, destinado a acoger aeronaves y helicópteros  para el embarque y desembarque de pasajeros, correo o carga y para abastecerse de combustible, estacionamiento  o mantenimiento.', 171);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('GB035', 'Helipuerto', 'Aeródromo utilizado para aterrizaje y despegue vertical de helicópteros.', 172);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('GB055', 'Pista de Aterrizaje', 'Área rectangular definida en un campo de aviación o aeropuerto, utilizada para despegue y aterrizaje de aeronaves.', 173);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('GB075', 'Pista de Rodadura', 'Ruta definida en un aeródromo, establecido para  el rodaje de aeronaves  y destinada a proporcionar un enlace de movimiento en tierra  entre una parte del aeródromo y otra.', 174);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('SU001', 'Base Militar', 'Conjunto de instalaciones destinadas para el uso militar, que proporcionan apoyo en combate, a fin de que cuenten con las mejores condiciones operativas para el cumplimiento de las tareas asignadas; brindando un soporte  logístico, técnico y de seguridad necesarios.', 175);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AT045', 'Estación de Radar', 'Instalación que utiliza el radar para detectar y analizar objetos (por ejemplo: aviones, buques, satélites artificiales, asteroides, y/o misiles) y/o fenómenos ambientales (por ejemplo: tornados).', 177);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AM065', 'Instalación de Almacenamiento de Municiones', 'Depósito para el almacenamiento y mantenimiento de municiones y explosivos (por ejemplo: bombas, misiles, ojivas, minas o municiones).', 178);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AH070', 'Puesto de Control', 'Lugar donde se registran, declaran y/o inspeccionan bienes y/o personas.', 179);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL121', 'Zona de Artillería Anti-Aérea', 'Zona de instalaciones relacionadas (por ejemplo: edificios y/o equipos de radar) para el almacenamiento y emplazamiento de artillería anti-aérea.', 180);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('FC050', 'Área de Disparo y/o Práctica Naval', 'Área donde la fuerza naval (por ejemplo:buques o aeronaves) ejecutan ejercicios de disparo de munición  y lanzamiento de misiles en forma real.', 181);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('FA165', 'Área de Entrenamiento', 'Sitio destinado a la instrucción y adiestramiento especializado del personal movilizado para completar las dotaciones de guerra de las unidades y reparticiones del ejercito, así como para proporcionar los reemplazos necesarios a las tropas en combate.', 182);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('FC055', 'Área de Operaciones Navales', 'Área donde la fuerza naval ejecuta operaciones.', 183);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('FC200', 'Campo Minado', 'Parte del terreno sembrado de minas Antitanques y Antipersonal está destinado a retardar, desgastar y encauzar al adversario. En guerra naval es área de mar sembrada de minas antibuque y/o antisubmarinas, con el propósito de impedir el tráfico marítimo enemigo y/o proteger lugares de interés en el litoral, tales como puertos, bahías y canales.', 184);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('FA021', 'Límite Marítimo', 'Línea donde actividades determinadas o ciertos factores aplican tanto para la navegación u operación.', 185);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('FA015', 'Polígono de Tiro', 'Sitio designado con el propósito de disparar municiones y detonar explosivos.', 186);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('FA517', 'Unidad Militar', 'Área que es de responsabilidad de un comando jurisdiccional.', 187);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('FC046', 'Área de un Cuerpo de Agua', 'Cuerpo de agua geográficamente definido (por ejemplo: el mar u otras aguas navegables).', 188);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('ZI015', 'Colección de Nombres', 'Conjunto de nombres geográficos recogidos por una entidad de modelo que los utiliza para denotar una características junto con una ubicación geográfica adecuada para su uso en nomenclátor.', 189);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('DA031', 'Denominación de la Parcela de Tierra', 'Parcela de un territorio natural, definido por sus características geográficas y conocido por su propio nombre.', 190);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('ZD040', 'Nombre de Sitio', 'Sitio geográfico sobre la superficie de la tierra que tiene nombre propio.', 191);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('ZI005', 'Nombre Geográfico', 'Nombre usado para denotar un objeto y la información de relación para establecer el contexto del uso, por parte de una entidad de modelo específica (por ejemplo: base de datos geográfica).', 192);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('DB000', 'Superficie de la Tierra', 'Parte de la tierra geográficamente definida.', 193);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('ZI033', 'Series', 'Para representar las hojas que de acuerdo a la escala se dividen para cubrir el país', 194);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('ZD012', 'Punto de Información Geográfica', 'Región en la que múltiples características que tiene la misma función  se representa como  objeto contiguo agregado.', 196);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AI030', 'Campamento Militar', 'Instalaciones generalmente en terreno abierto que pueden ser movidas con facilidad, sirven como residencia a tiempo completo o temporal.', 176);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BD122', 'Banco de Arena', 'Acumulación de arena, grava o guijarros en el lecho de un río.', 0);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH165', 'Aliviadero', 'Estructura hidráulica destinada a permitir el pase libre o controlado del agua en los escurrimientos superficiales; siendo el aliviadero en exclusiva para el desagüe.', 0);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ035', 'Acera', 'Ruta pavimentada o mejorada para uso del peatón, normalmente se encuentra adyacente y paralela a una calle o carretera. ', 197);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ037', 'Bordillo', 'Borde de hormigón, asfalto o piedras que forman el borde de una acera a lo largo de la orilla de una calle o carretera. Se debe incluir aquellos que formen parte de los parterres.', 198);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AJ110', 'Invernadero', 'Edificio construido principalmente de material transparente en el que la temperatura y la humedad puede ser controlada para el cultivo y/o protección de plantas.', 199);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('ZB050', 'Punto de Control', 'Objeto en el terreno de ubicación conocida, donde se ha determinado las coordenadas horizontal y/o vertical por métodos geodésicos o topográficos.', 200);


--
-- TOC entry 7341 (class 0 OID 2456969)
-- Dependencies: 316
-- Data for Name: dit; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.dit VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.dit VALUES (1, '1.- Irrigación');
INSERT INTO catalogo_objetos.dit VALUES (2, '2.- Drenaje');
INSERT INTO catalogo_objetos.dit VALUES (3, '3.- Aguas residuales');
INSERT INTO catalogo_objetos.dit VALUES (998, '998.- No aplica');


--
-- TOC entry 7342 (class 0 OID 2456972)
-- Dependencies: 317
-- Data for Name: ela; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.ela VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.ela VALUES (1, '1.- Preciso');
INSERT INTO catalogo_objetos.ela VALUES (2, '2.- Aproximado');
INSERT INTO catalogo_objetos.ela VALUES (998, '998.- No aplica');


--
-- TOC entry 7343 (class 0 OID 2456975)
-- Dependencies: 318
-- Data for Name: fco; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.fco VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.fco VALUES (1, '1.- Disperso');
INSERT INTO catalogo_objetos.fco VALUES (5, '5.- Divido en igual ancho');
INSERT INTO catalogo_objetos.fco VALUES (6, '6.- Dividido en diferente ancho');
INSERT INTO catalogo_objetos.fco VALUES (7, '7.- Sin divisiones');
INSERT INTO catalogo_objetos.fco VALUES (998, '998.- No aplica');


--
-- TOC entry 7344 (class 0 OID 2456978)
-- Dependencies: 319
-- Data for Name: fti; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.fti VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.fti VALUES (1, '1.- Metal');
INSERT INTO catalogo_objetos.fti VALUES (2, '2.- Madera');
INSERT INTO catalogo_objetos.fti VALUES (3, '3.- Mampostería');
INSERT INTO catalogo_objetos.fti VALUES (4, '4.- Roca');
INSERT INTO catalogo_objetos.fti VALUES (5, '5.- Alambre de púas');
INSERT INTO catalogo_objetos.fti VALUES (6, '6.- Malla');
INSERT INTO catalogo_objetos.fti VALUES (7, '7.- Cable electrificado');
INSERT INTO catalogo_objetos.fti VALUES (8, '8.- Geotextil');
INSERT INTO catalogo_objetos.fti VALUES (9, '9.- Redes');
INSERT INTO catalogo_objetos.fti VALUES (998, '998.- No aplica');


--
-- TOC entry 7345 (class 0 OID 2456981)
-- Dependencies: 320
-- Data for Name: fuc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.fuc VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.fuc VALUES (1, '1.- Industrial');
INSERT INTO catalogo_objetos.fuc VALUES (2, '2.- Comercial');
INSERT INTO catalogo_objetos.fuc VALUES (3, '3.- Institucional');
INSERT INTO catalogo_objetos.fuc VALUES (4, '4.- Residencial');
INSERT INTO catalogo_objetos.fuc VALUES (5, '5.- Agricultura');
INSERT INTO catalogo_objetos.fuc VALUES (6, '6.- Marítimo');
INSERT INTO catalogo_objetos.fuc VALUES (8, '8.- Refugio');
INSERT INTO catalogo_objetos.fuc VALUES (9, '9.- Correccional');
INSERT INTO catalogo_objetos.fuc VALUES (10, '10.- Santuario de vida salvaje');
INSERT INTO catalogo_objetos.fuc VALUES (12, '12.- Reserva');
INSERT INTO catalogo_objetos.fuc VALUES (13, '13.- Recreacional');
INSERT INTO catalogo_objetos.fuc VALUES (19, '19.- Urbanización multifuncional');
INSERT INTO catalogo_objetos.fuc VALUES (20, '20.- Transportación');
INSERT INTO catalogo_objetos.fuc VALUES (23, '23.- Medicina');
INSERT INTO catalogo_objetos.fuc VALUES (24, '24.- Preservación forestal');
INSERT INTO catalogo_objetos.fuc VALUES (26, '26.- Educacional');
INSERT INTO catalogo_objetos.fuc VALUES (27, '27.- No comercial');
INSERT INTO catalogo_objetos.fuc VALUES (31, '31.- Cultural');
INSERT INTO catalogo_objetos.fuc VALUES (32, '32.- Gubernamental');
INSERT INTO catalogo_objetos.fuc VALUES (33, '33.- Área prohibida');
INSERT INTO catalogo_objetos.fuc VALUES (34, '34.- Servicio público');
INSERT INTO catalogo_objetos.fuc VALUES (35, '35.- Religioso');
INSERT INTO catalogo_objetos.fuc VALUES (36, '36.- Seguridad');
INSERT INTO catalogo_objetos.fuc VALUES (37, '37.- Militar');
INSERT INTO catalogo_objetos.fuc VALUES (38, '38.- Empresa de Servicio Público');
INSERT INTO catalogo_objetos.fuc VALUES (39, '39.- Recursos para ingeniería o construcción');
INSERT INTO catalogo_objetos.fuc VALUES (40, '40.- Almacenamiento al granel');
INSERT INTO catalogo_objetos.fuc VALUES (41, '41.- Área de oficina');
INSERT INTO catalogo_objetos.fuc VALUES (42, '42.- Investigación');
INSERT INTO catalogo_objetos.fuc VALUES (998, '998.- No aplica');


--
-- TOC entry 7346 (class 0 OID 2456984)
-- Dependencies: 321
-- Data for Name: hct; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.hct VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.hct VALUES (1, '1.- Ruta primaria');
INSERT INTO catalogo_objetos.hct VALUES (2, '2.- Ruta secundaria');
INSERT INTO catalogo_objetos.hct VALUES (3, '3.- Autopista nacional');
INSERT INTO catalogo_objetos.hct VALUES (4, '4.- Ruta local');
INSERT INTO catalogo_objetos.hct VALUES (998, '998.- No aplica');


--
-- TOC entry 7347 (class 0 OID 2456987)
-- Dependencies: 322
-- Data for Name: hyp; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.hyp VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.hyp VALUES (1, '1.- Perenne');
INSERT INTO catalogo_objetos.hyp VALUES (2, '2.- Intermitente');
INSERT INTO catalogo_objetos.hyp VALUES (3, '3.- Eventual');
INSERT INTO catalogo_objetos.hyp VALUES (4, '4.- Seco');
INSERT INTO catalogo_objetos.hyp VALUES (998, '998.- No aplica');


--
-- TOC entry 7348 (class 0 OID 2456990)
-- Dependencies: 323
-- Data for Name: kos; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.kos VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.kos VALUES (1, '1.- Fútbol');
INSERT INTO catalogo_objetos.kos VALUES (2, '2.- Campo de atletismo');
INSERT INTO catalogo_objetos.kos VALUES (3, '3.- Tenis');
INSERT INTO catalogo_objetos.kos VALUES (4, '4.- Equitación');
INSERT INTO catalogo_objetos.kos VALUES (5, '5.- Natación');
INSERT INTO catalogo_objetos.kos VALUES (6, '6.- Pista de esquí');
INSERT INTO catalogo_objetos.kos VALUES (7, '7.- Patinaje de hielo');
INSERT INTO catalogo_objetos.kos VALUES (8, '8.- Deportes de motor');
INSERT INTO catalogo_objetos.kos VALUES (10, '10.- Carreras de perros');
INSERT INTO catalogo_objetos.kos VALUES (11, '11.- Esquí a campo traviesa');
INSERT INTO catalogo_objetos.kos VALUES (12, '12.- Golf');
INSERT INTO catalogo_objetos.kos VALUES (13, '13.- Navegación a vela');
INSERT INTO catalogo_objetos.kos VALUES (14, '14.- Pista de obstáculos');
INSERT INTO catalogo_objetos.kos VALUES (998, '998.- No aplica');


--
-- TOC entry 7349 (class 0 OID 2456993)
-- Dependencies: 324
-- Data for Name: loc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.loc VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.loc VALUES (17, '17.- Sobre el fondo de un cuerpo de agua');
INSERT INTO catalogo_objetos.loc VALUES (23, '23.- Bajo el fondo del cuerpo de agua');
INSERT INTO catalogo_objetos.loc VALUES (40, '40.- Bajo la superficie');
INSERT INTO catalogo_objetos.loc VALUES (44, '44.- En la superficie');
INSERT INTO catalogo_objetos.loc VALUES (45, '45.- Sobre la superficie');
INSERT INTO catalogo_objetos.loc VALUES (46, '46.- Sobre el fondo del cuerpo de agua');
INSERT INTO catalogo_objetos.loc VALUES (47, '47.- Bajo la superficie del cuerpo de agua');
INSERT INTO catalogo_objetos.loc VALUES (998, '998.- No aplica');


--
-- TOC entry 7350 (class 0 OID 2456996)
-- Dependencies: 325
-- Data for Name: mes; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.mes VALUES (0, '0.- Falso');
INSERT INTO catalogo_objetos.mes VALUES (1, '1.- Verdadero');


--
-- TOC entry 7351 (class 0 OID 2456999)
-- Dependencies: 326
-- Data for Name: rdt; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.rdt VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.rdt VALUES (2, '2.- Tránsito rápido');
INSERT INTO catalogo_objetos.rdt VALUES (3, '3.- Privada');
INSERT INTO catalogo_objetos.rdt VALUES (4, '4.- Servicio');
INSERT INTO catalogo_objetos.rdt VALUES (5, '5.- Alta velocidad');
INSERT INTO catalogo_objetos.rdt VALUES (6, '6.- Ruta');
INSERT INTO catalogo_objetos.rdt VALUES (7, '7.- Circunvalación');
INSERT INTO catalogo_objetos.rdt VALUES (11, '11.- Camino corto');
INSERT INTO catalogo_objetos.rdt VALUES (45, '45.- Camino de herradura');
INSERT INTO catalogo_objetos.rdt VALUES (46, '46.- Cruce/intersección de caminos');
INSERT INTO catalogo_objetos.rdt VALUES (998, '998.- No aplica');


--
-- TOC entry 7352 (class 0 OID 2457002)
-- Dependencies: 327
-- Data for Name: rel; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.rel VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.rel VALUES (1, '1.- Budismo');
INSERT INTO catalogo_objetos.rel VALUES (2, '2.- Islam');
INSERT INTO catalogo_objetos.rel VALUES (3, '3.- Católica Romana');
INSERT INTO catalogo_objetos.rel VALUES (4, '4.- Cristiana');
INSERT INTO catalogo_objetos.rel VALUES (5, '5.- Judaísmo');
INSERT INTO catalogo_objetos.rel VALUES (6, '6.- Ortodoxa');
INSERT INTO catalogo_objetos.rel VALUES (7, '7.- Protestante');
INSERT INTO catalogo_objetos.rel VALUES (8, '8.- Sintoísmo');
INSERT INTO catalogo_objetos.rel VALUES (9, '9.- Hinduismo');
INSERT INTO catalogo_objetos.rel VALUES (10, '10.- Chiísmo');
INSERT INTO catalogo_objetos.rel VALUES (11, '11.- Suníes');
INSERT INTO catalogo_objetos.rel VALUES (12, '12.- Nestoriana');
INSERT INTO catalogo_objetos.rel VALUES (13, '13.- Caldea');
INSERT INTO catalogo_objetos.rel VALUES (15, '15.- Religión tribal');
INSERT INTO catalogo_objetos.rel VALUES (998, '998.- No aplica');


--
-- TOC entry 7353 (class 0 OID 2457005)
-- Dependencies: 328
-- Data for Name: rgc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.rgc VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.rgc VALUES (1, '1.- Amplia');
INSERT INTO catalogo_objetos.rgc VALUES (2, '2.- Angosta/estrecha');
INSERT INTO catalogo_objetos.rgc VALUES (3, '3.- Estándar/normal');
INSERT INTO catalogo_objetos.rgc VALUES (6, '6.- Monocarril');
INSERT INTO catalogo_objetos.rgc VALUES (998, '998.- No aplica');


--
-- TOC entry 7354 (class 0 OID 2457008)
-- Dependencies: 329
-- Data for Name: rra; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.rra VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.rra VALUES (1, '1.- Carril electrificado');
INSERT INTO catalogo_objetos.rra VALUES (3, '3.- Electrificación aérea');
INSERT INTO catalogo_objetos.rra VALUES (4, '4.- No electrificada');
INSERT INTO catalogo_objetos.rra VALUES (998, '998.- No aplica');


--
-- TOC entry 7355 (class 0 OID 2457011)
-- Dependencies: 330
-- Data for Name: rrc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.rrc VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.rrc VALUES (2, '2.- Carline');
INSERT INTO catalogo_objetos.rrc VALUES (6, '6.- Ferrocarril subterráneo');
INSERT INTO catalogo_objetos.rrc VALUES (8, '8.- Transporte para madera');
INSERT INTO catalogo_objetos.rrc VALUES (10, '10.- Miniatura');
INSERT INTO catalogo_objetos.rrc VALUES (11, '11.- Tránsito rápido (Metro)');
INSERT INTO catalogo_objetos.rrc VALUES (13, '13.- Ferrocarril ayuda marina');
INSERT INTO catalogo_objetos.rrc VALUES (14, '14.- Tranvía');
INSERT INTO catalogo_objetos.rrc VALUES (15, '15.- Funicular');
INSERT INTO catalogo_objetos.rrc VALUES (24, '24.- Museo');
INSERT INTO catalogo_objetos.rrc VALUES (32, '32.- Sistema de tránsito automatizado');
INSERT INTO catalogo_objetos.rrc VALUES (33, '33.- Larga distancia');
INSERT INTO catalogo_objetos.rrc VALUES (998, '998.-  No aplica');


--
-- TOC entry 7356 (class 0 OID 2457014)
-- Dependencies: 331
-- Data for Name: rst; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.rst VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.rst VALUES (1, '1.- Duro/pavimentado');
INSERT INTO catalogo_objetos.rst VALUES (2, '2.- Suelto/no pavimentado');
INSERT INTO catalogo_objetos.rst VALUES (3, '3.- Suelto/ligero');
INSERT INTO catalogo_objetos.rst VALUES (4, '4.- Troncos entrecruzados');
INSERT INTO catalogo_objetos.rst VALUES (5, '5.- Hierba/césped');
INSERT INTO catalogo_objetos.rst VALUES (6, '6.- Sin mejoras');
INSERT INTO catalogo_objetos.rst VALUES (7, '7.- Permanente');
INSERT INTO catalogo_objetos.rst VALUES (8, '8.- Temporal');
INSERT INTO catalogo_objetos.rst VALUES (9, '9.- Composición dura');
INSERT INTO catalogo_objetos.rst VALUES (10, '10.- PEM');
INSERT INTO catalogo_objetos.rst VALUES (11, '11.- Bituminosas');
INSERT INTO catalogo_objetos.rst VALUES (12, '12.- Composición suave');
INSERT INTO catalogo_objetos.rst VALUES (13, '13.- Tierra clasificada');
INSERT INTO catalogo_objetos.rst VALUES (14, '14.- Tierra sin clasificar');
INSERT INTO catalogo_objetos.rst VALUES (15, '15.- Hielo');
INSERT INTO catalogo_objetos.rst VALUES (16, '16.- Nieve');
INSERT INTO catalogo_objetos.rst VALUES (17, '17.- Macadán');
INSERT INTO catalogo_objetos.rst VALUES (18, '18.- Membrana');
INSERT INTO catalogo_objetos.rst VALUES (19, '19.- Mezcla');
INSERT INTO catalogo_objetos.rst VALUES (20, '20.- Laterita');
INSERT INTO catalogo_objetos.rst VALUES (21, '21.- Arena');
INSERT INTO catalogo_objetos.rst VALUES (22, '22.- Asfalto sobre concreto');
INSERT INTO catalogo_objetos.rst VALUES (23, '23.- Encofrado de acero perforado');
INSERT INTO catalogo_objetos.rst VALUES (24, '24.- Grava');
INSERT INTO catalogo_objetos.rst VALUES (25, '25.- Coral');
INSERT INTO catalogo_objetos.rst VALUES (26, '26.- Arcilla');
INSERT INTO catalogo_objetos.rst VALUES (27, '27.- Concreto');
INSERT INTO catalogo_objetos.rst VALUES (28, '28.- Ladrillo');
INSERT INTO catalogo_objetos.rst VALUES (29, '29.- Asfáltica');
INSERT INTO catalogo_objetos.rst VALUES (30, '30.- Ceniza');
INSERT INTO catalogo_objetos.rst VALUES (31, '31.- Empedrada');
INSERT INTO catalogo_objetos.rst VALUES (32, '32.- Concha');
INSERT INTO catalogo_objetos.rst VALUES (33, '33.- Tablón de madera');
INSERT INTO catalogo_objetos.rst VALUES (998, '998.- No aplica');


--
-- TOC entry 7357 (class 0 OID 2457017)
-- Dependencies: 332
-- Data for Name: slt; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.slt VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.slt VALUES (6, '6.- Manglar');
INSERT INTO catalogo_objetos.slt VALUES (8, '8.- Pantano');
INSERT INTO catalogo_objetos.slt VALUES (11, '11.- Escombros de construcción');
INSERT INTO catalogo_objetos.slt VALUES (12, '12.- Escombros de erosión');
INSERT INTO catalogo_objetos.slt VALUES (13, '13.- Arenoso');
INSERT INTO catalogo_objetos.slt VALUES (14, '14.- Guijarros');
INSERT INTO catalogo_objetos.slt VALUES (15, '15.- Rocoso');
INSERT INTO catalogo_objetos.slt VALUES (16, '16.- Coral');
INSERT INTO catalogo_objetos.slt VALUES (17, '17.- Hielo');
INSERT INTO catalogo_objetos.slt VALUES (18, '18.- Barro');
INSERT INTO catalogo_objetos.slt VALUES (998, '998.- No aplica');


--
-- TOC entry 7358 (class 0 OID 2457020)
-- Dependencies: 333
-- Data for Name: smc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.smc VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.smc VALUES (2, '2.- Aluminio');
INSERT INTO catalogo_objetos.smc VALUES (4, '4.- Ceniza');
INSERT INTO catalogo_objetos.smc VALUES (5, '5.- Asfalto');
INSERT INTO catalogo_objetos.smc VALUES (6, '6.- Basalto');
INSERT INTO catalogo_objetos.smc VALUES (7, '7.- Roca Madre');
INSERT INTO catalogo_objetos.smc VALUES (8, '8.- Cantos Rodados');
INSERT INTO catalogo_objetos.smc VALUES (9, '9.- Ladrillo');
INSERT INTO catalogo_objetos.smc VALUES (10, '10.- Calcáreo');
INSERT INTO catalogo_objetos.smc VALUES (12, '12.- Tiza');
INSERT INTO catalogo_objetos.smc VALUES (14, '14.- Cenizas');
INSERT INTO catalogo_objetos.smc VALUES (15, '15.- Cirripedia');
INSERT INTO catalogo_objetos.smc VALUES (16, '16.- Arcilla');
INSERT INTO catalogo_objetos.smc VALUES (17, '17.- Carbón');
INSERT INTO catalogo_objetos.smc VALUES (18, '18.- Empedrado');
INSERT INTO catalogo_objetos.smc VALUES (19, '19.- Coque');
INSERT INTO catalogo_objetos.smc VALUES (20, '20.- Composición');
INSERT INTO catalogo_objetos.smc VALUES (21, '21.- Concreto u Hormigón');
INSERT INTO catalogo_objetos.smc VALUES (22, '22.- Conglomerado');
INSERT INTO catalogo_objetos.smc VALUES (23, '23.- Cobre');
INSERT INTO catalogo_objetos.smc VALUES (24, '24.- Coral');
INSERT INTO catalogo_objetos.smc VALUES (25, '25.- Coral Head');
INSERT INTO catalogo_objetos.smc VALUES (28, '28.- Tierra de diatomeas');
INSERT INTO catalogo_objetos.smc VALUES (29, '29.- Dolomita');
INSERT INTO catalogo_objetos.smc VALUES (34, '34.- Flysch');
INSERT INTO catalogo_objetos.smc VALUES (36, '36.- Foraminíferos');
INSERT INTO catalogo_objetos.smc VALUES (37, '37.- Fucus');
INSERT INTO catalogo_objetos.smc VALUES (40, '40.- Vidrio');
INSERT INTO catalogo_objetos.smc VALUES (42, '42.- Oro');
INSERT INTO catalogo_objetos.smc VALUES (43, '43.- Granito');
INSERT INTO catalogo_objetos.smc VALUES (45, '45.- Materia vegetal');
INSERT INTO catalogo_objetos.smc VALUES (46, '46.- Grava');
INSERT INTO catalogo_objetos.smc VALUES (47, '47.- Rocaverde (Jade)');
INSERT INTO catalogo_objetos.smc VALUES (49, '49.- Suelo  de conchas');
INSERT INTO catalogo_objetos.smc VALUES (51, '51.- Hierro');
INSERT INTO catalogo_objetos.smc VALUES (52, '52.- Lava');
INSERT INTO catalogo_objetos.smc VALUES (54, '54.- Plomo');
INSERT INTO catalogo_objetos.smc VALUES (55, '55.- Loess');
INSERT INTO catalogo_objetos.smc VALUES (56, '56.- Maderos');
INSERT INTO catalogo_objetos.smc VALUES (57, '57.- Macadán');
INSERT INTO catalogo_objetos.smc VALUES (58, '58.- Madrépora');
INSERT INTO catalogo_objetos.smc VALUES (59, '59.- Manganeso');
INSERT INTO catalogo_objetos.smc VALUES (60, '60.- Mármol');
INSERT INTO catalogo_objetos.smc VALUES (61, '61.- Marga');
INSERT INTO catalogo_objetos.smc VALUES (62, '62.- Mampostería');
INSERT INTO catalogo_objetos.smc VALUES (63, '63.- Mate');
INSERT INTO catalogo_objetos.smc VALUES (64, '64.- Metal');
INSERT INTO catalogo_objetos.smc VALUES (65, '65.- Barro');
INSERT INTO catalogo_objetos.smc VALUES (66, '66.- Mejillones');
INSERT INTO catalogo_objetos.smc VALUES (67, '67.- Aceite');
INSERT INTO catalogo_objetos.smc VALUES (69, '69.- Cieno');
INSERT INTO catalogo_objetos.smc VALUES (70, '70.- Ostras');
INSERT INTO catalogo_objetos.smc VALUES (71, '71.- Papel');
INSERT INTO catalogo_objetos.smc VALUES (72, '72.- Parte  Metálica');
INSERT INTO catalogo_objetos.smc VALUES (73, '73.- Guijarros');
INSERT INTO catalogo_objetos.smc VALUES (74, '74.- Plástico');
INSERT INTO catalogo_objetos.smc VALUES (75, '75.- Algas marinas');
INSERT INTO catalogo_objetos.smc VALUES (76, '76.- Pórfido');
INSERT INTO catalogo_objetos.smc VALUES (77, '77.- Hormigón pretensado');
INSERT INTO catalogo_objetos.smc VALUES (79, '79.- Piedra Pómez');
INSERT INTO catalogo_objetos.smc VALUES (80, '80.- Cuarzo');
INSERT INTO catalogo_objetos.smc VALUES (81, '81.- Radiolario');
INSERT INTO catalogo_objetos.smc VALUES (82, '82.- Material radiactivo');
INSERT INTO catalogo_objetos.smc VALUES (83, '83.- Hormigón armado');
INSERT INTO catalogo_objetos.smc VALUES (84, '84.- Piedras');
INSERT INTO catalogo_objetos.smc VALUES (85, '85.- Caucho');
INSERT INTO catalogo_objetos.smc VALUES (86, '86.- Escombros');
INSERT INTO catalogo_objetos.smc VALUES (87, '87.- Sal');
INSERT INTO catalogo_objetos.smc VALUES (88, '88.- Arena');
INSERT INTO catalogo_objetos.smc VALUES (89, '89.- Arenisca');
INSERT INTO catalogo_objetos.smc VALUES (90, '90.- Esquisto');
INSERT INTO catalogo_objetos.smc VALUES (91, '91.- Desperdicio de minas');
INSERT INTO catalogo_objetos.smc VALUES (92, '92.- Escoria');
INSERT INTO catalogo_objetos.smc VALUES (95, '95.- Aguas Residuales');
INSERT INTO catalogo_objetos.smc VALUES (96, '96.- Concha');
INSERT INTO catalogo_objetos.smc VALUES (98, '98.- Guijarro');
INSERT INTO catalogo_objetos.smc VALUES (99, '99.- Limo');
INSERT INTO catalogo_objetos.smc VALUES (100, '100.- Plata');
INSERT INTO catalogo_objetos.smc VALUES (101, '101.- Desechos de metales');
INSERT INTO catalogo_objetos.smc VALUES (102, '102.- Lodos');
INSERT INTO catalogo_objetos.smc VALUES (103, '103.- Agua congelada');
INSERT INTO catalogo_objetos.smc VALUES (104, '104.- Suelo');
INSERT INTO catalogo_objetos.smc VALUES (105, '105.- Espículas');
INSERT INTO catalogo_objetos.smc VALUES (106, '106.- Esponja');
INSERT INTO catalogo_objetos.smc VALUES (107, '107.- Acero');
INSERT INTO catalogo_objetos.smc VALUES (108, '108.- Piedra preciosa');
INSERT INTO catalogo_objetos.smc VALUES (110, '110.- Travertino');
INSERT INTO catalogo_objetos.smc VALUES (111, '111.- Toba');
INSERT INTO catalogo_objetos.smc VALUES (112, '112.- Mineral de  uranio');
INSERT INTO catalogo_objetos.smc VALUES (113, '113.- Vegetación');
INSERT INTO catalogo_objetos.smc VALUES (115, '115.- Ceniza Volcánica');
INSERT INTO catalogo_objetos.smc VALUES (116, '116.- Agua');
INSERT INTO catalogo_objetos.smc VALUES (117, '117.- Madera');
INSERT INTO catalogo_objetos.smc VALUES (118, '118.- Zinc');
INSERT INTO catalogo_objetos.smc VALUES (120, '120.- Arena y Grava');
INSERT INTO catalogo_objetos.smc VALUES (121, '121.- Escollera');
INSERT INTO catalogo_objetos.smc VALUES (122, '122.- Evaporita');
INSERT INTO catalogo_objetos.smc VALUES (124, '124.- Arena y rocas');
INSERT INTO catalogo_objetos.smc VALUES (126, '126.- Arena y barro');
INSERT INTO catalogo_objetos.smc VALUES (128, '128.- Plástico reforzado con vidrio (GRP)');
INSERT INTO catalogo_objetos.smc VALUES (129, '129.- Roca metomórfica');
INSERT INTO catalogo_objetos.smc VALUES (130, '130.- Roca  ígnea');
INSERT INTO catalogo_objetos.smc VALUES (131, '131.- Dolerita');
INSERT INTO catalogo_objetos.smc VALUES (205, '205.- Pintura');
INSERT INTO catalogo_objetos.smc VALUES (257, '257.- Hielo');
INSERT INTO catalogo_objetos.smc VALUES (258, '258.- Nieve');
INSERT INTO catalogo_objetos.smc VALUES (262, '262.- Laterita');
INSERT INTO catalogo_objetos.smc VALUES (266, '266.- Breccia');
INSERT INTO catalogo_objetos.smc VALUES (267, '267.- Cerámica');
INSERT INTO catalogo_objetos.smc VALUES (268, '268.- Gneis');
INSERT INTO catalogo_objetos.smc VALUES (269, '269.- Caliza');
INSERT INTO catalogo_objetos.smc VALUES (270, '270.- Cuarcita');
INSERT INTO catalogo_objetos.smc VALUES (271, '271.- Teja');
INSERT INTO catalogo_objetos.smc VALUES (272, '272.- Lutita – esquisto');
INSERT INTO catalogo_objetos.smc VALUES (273, '273.- Pizarra');
INSERT INTO catalogo_objetos.smc VALUES (274, '274.- Césped');
INSERT INTO catalogo_objetos.smc VALUES (275, '275.- Paja');
INSERT INTO catalogo_objetos.smc VALUES (276, '276.- Madero');
INSERT INTO catalogo_objetos.smc VALUES (277, '277.- Roca sedimentaria');
INSERT INTO catalogo_objetos.smc VALUES (278, '278.- Adobe');
INSERT INTO catalogo_objetos.smc VALUES (279, '279.- Madera tratada');
INSERT INTO catalogo_objetos.smc VALUES (280, '280.- Pasto');
INSERT INTO catalogo_objetos.smc VALUES (998, '998.- No aplica');


--
-- TOC entry 7359 (class 0 OID 2457023)
-- Dependencies: 334
-- Data for Name: tra; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.tra VALUES (0, '0.- Falso');
INSERT INTO catalogo_objetos.tra VALUES (1, '1.- Verdadero');


--
-- TOC entry 7360 (class 0 OID 2457026)
-- Dependencies: 335
-- Data for Name: tuc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.tuc VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.tuc VALUES (19, '19.- Ganadería');
INSERT INTO catalogo_objetos.tuc VALUES (25, '25.- Carga');
INSERT INTO catalogo_objetos.tuc VALUES (26, '26.- Pasajeros');
INSERT INTO catalogo_objetos.tuc VALUES (33, '33.- Minerales');
INSERT INTO catalogo_objetos.tuc VALUES (35, '35.- No para transporte');
INSERT INTO catalogo_objetos.tuc VALUES (45, '45.- General');
INSERT INTO catalogo_objetos.tuc VALUES (998, '998.- No aplica');


--
-- TOC entry 7361 (class 0 OID 2457029)
-- Dependencies: 336
-- Data for Name: typ; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.typ VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.typ VALUES (1, '1.- Carretera');
INSERT INTO catalogo_objetos.typ VALUES (5, '5.- Bulevar');
INSERT INTO catalogo_objetos.typ VALUES (9, '9.- Avenida');
INSERT INTO catalogo_objetos.typ VALUES (13, '13.- Paseo');
INSERT INTO catalogo_objetos.typ VALUES (17, '17.- Curva de retorno');
INSERT INTO catalogo_objetos.typ VALUES (21, '21.- Cerrada');
INSERT INTO catalogo_objetos.typ VALUES (25, '25.- Ruta verde (Parkway)');
INSERT INTO catalogo_objetos.typ VALUES (29, '29.- Pasaje');
INSERT INTO catalogo_objetos.typ VALUES (33, '33.- Calle');
INSERT INTO catalogo_objetos.typ VALUES (37, '37.- Terraza');
INSERT INTO catalogo_objetos.typ VALUES (41, '41.- Autopista');
INSERT INTO catalogo_objetos.typ VALUES (45, '45.- Plaza');
INSERT INTO catalogo_objetos.typ VALUES (46, '46.- Rodera');
INSERT INTO catalogo_objetos.typ VALUES (47, '47.- Autopista de acceso restringido');
INSERT INTO catalogo_objetos.typ VALUES (48, '48.- Redondel');
INSERT INTO catalogo_objetos.typ VALUES (49, '49.- Sendero');
INSERT INTO catalogo_objetos.typ VALUES (50, '50.- Rampa');
INSERT INTO catalogo_objetos.typ VALUES (998, '998.- No aplica');


--
-- TOC entry 7362 (class 0 OID 2457032)
-- Dependencies: 337
-- Data for Name: uuc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.uuc VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.uuc VALUES (4, '4.- Transformador');
INSERT INTO catalogo_objetos.uuc VALUES (5, '5.- Desagüe');
INSERT INTO catalogo_objetos.uuc VALUES (6, '6.- Represa');
INSERT INTO catalogo_objetos.uuc VALUES (7, '7.- Agua potable');
INSERT INTO catalogo_objetos.uuc VALUES (9, '9.- Dependencia');
INSERT INTO catalogo_objetos.uuc VALUES (10, '10.- Central eléctrica');
INSERT INTO catalogo_objetos.uuc VALUES (11, '11.- Planta de filtración');
INSERT INTO catalogo_objetos.uuc VALUES (12, '12.- Refrigeración');
INSERT INTO catalogo_objetos.uuc VALUES (18, '18.- Central de abastecimiento de agua');
INSERT INTO catalogo_objetos.uuc VALUES (998, '998.- No aplica');


--
-- TOC entry 7363 (class 0 OID 2457035)
-- Dependencies: 338
-- Data for Name: wtc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.wtc VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.wtc VALUES (1, '1.- Todo el tiempo (todo el año)');
INSERT INTO catalogo_objetos.wtc VALUES (3, '3.- Solamente en invierno');
INSERT INTO catalogo_objetos.wtc VALUES (4, '4.- Limitada todo el tiempo');
INSERT INTO catalogo_objetos.wtc VALUES (5, '5.- Cerrada en invierno');
INSERT INTO catalogo_objetos.wtc VALUES (998, '998.- No aplica');
INSERT INTO catalogo_objetos.wtc VALUES (2, '2.- Buen clima (época seca)');


--
-- TOC entry 7364 (class 0 OID 2457038)
-- Dependencies: 339
-- Data for Name: wti; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.wti VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.wti VALUES (1, '1.- Independiente');
INSERT INTO catalogo_objetos.wti VALUES (2, '2.- Retener (obstaculizar)');
INSERT INTO catalogo_objetos.wti VALUES (4, '4.- Cercado con árboles');
INSERT INTO catalogo_objetos.wti VALUES (5, '5.- Cerramiento');
INSERT INTO catalogo_objetos.wti VALUES (998, '998.- No aplica');


--
-- TOC entry 7365 (class 0 OID 2457041)
-- Dependencies: 340
-- Data for Name: punto_control_p; Type: TABLE DATA; Schema: d_linderos_propiedad; Owner: postgres
--



--
-- TOC entry 7367 (class 0 OID 2457053)
-- Dependencies: 342
-- Data for Name: cementerio_a; Type: TABLE DATA; Schema: gs_asociado_poblados; Owner: postgres
--



--
-- TOC entry 7369 (class 0 OID 2457065)
-- Dependencies: 344
-- Data for Name: cerca_l; Type: TABLE DATA; Schema: gs_asociado_poblados; Owner: postgres
--



--
-- TOC entry 7371 (class 0 OID 2457077)
-- Dependencies: 346
-- Data for Name: escalinata_a; Type: TABLE DATA; Schema: gs_asociado_poblados; Owner: postgres
--



--
-- TOC entry 7373 (class 0 OID 2457089)
-- Dependencies: 348
-- Data for Name: muro_l; Type: TABLE DATA; Schema: gs_asociado_poblados; Owner: postgres
--



--
-- TOC entry 7375 (class 0 OID 2457101)
-- Dependencies: 350
-- Data for Name: plaza_publica_a; Type: TABLE DATA; Schema: gs_asociado_poblados; Owner: postgres
--



--
-- TOC entry 7377 (class 0 OID 2457113)
-- Dependencies: 352
-- Data for Name: edificio_a; Type: TABLE DATA; Schema: gs_construcciones; Owner: postgres
--



--
-- TOC entry 7379 (class 0 OID 2457125)
-- Dependencies: 354
-- Data for Name: cancha_a; Type: TABLE DATA; Schema: gs_recreacion; Owner: postgres
--



--
-- TOC entry 7381 (class 0 OID 2457137)
-- Dependencies: 356
-- Data for Name: estadio_a; Type: TABLE DATA; Schema: gs_recreacion; Owner: postgres
--



--
-- TOC entry 7383 (class 0 OID 2457149)
-- Dependencies: 358
-- Data for Name: parque_a; Type: TABLE DATA; Schema: gs_recreacion; Owner: postgres
--



--
-- TOC entry 7385 (class 0 OID 2457161)
-- Dependencies: 360
-- Data for Name: piscina_a; Type: TABLE DATA; Schema: gs_recreacion; Owner: postgres
--



--
-- TOC entry 7387 (class 0 OID 2457173)
-- Dependencies: 362
-- Data for Name: plaza_toros_a; Type: TABLE DATA; Schema: gs_recreacion; Owner: postgres
--



--
-- TOC entry 7389 (class 0 OID 2457185)
-- Dependencies: 364
-- Data for Name: acequia_l; Type: TABLE DATA; Schema: ho_aguas_interiores; Owner: postgres
--



--
-- TOC entry 7391 (class 0 OID 2457197)
-- Dependencies: 366
-- Data for Name: acueducto_canal_a; Type: TABLE DATA; Schema: ho_aguas_interiores; Owner: postgres
--



--
-- TOC entry 7393 (class 0 OID 2457209)
-- Dependencies: 368
-- Data for Name: lago_laguna_a; Type: TABLE DATA; Schema: ho_aguas_interiores; Owner: postgres
--



--
-- TOC entry 7395 (class 0 OID 2457221)
-- Dependencies: 370
-- Data for Name: rio_a; Type: TABLE DATA; Schema: ho_aguas_interiores; Owner: postgres
--



--
-- TOC entry 7397 (class 0 OID 2457233)
-- Dependencies: 372
-- Data for Name: rio_l; Type: TABLE DATA; Schema: ho_aguas_interiores; Owner: postgres
--



--
-- TOC entry 7399 (class 0 OID 2457245)
-- Dependencies: 374
-- Data for Name: zanja_l; Type: TABLE DATA; Schema: ho_aguas_interiores; Owner: postgres
--



--
-- TOC entry 7401 (class 0 OID 2457257)
-- Dependencies: 376
-- Data for Name: puerto_a; Type: TABLE DATA; Schema: ho_puertos_muelles; Owner: postgres
--



--
-- TOC entry 7403 (class 0 OID 2457269)
-- Dependencies: 378
-- Data for Name: granja_acuatica_a; Type: TABLE DATA; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--



--
-- TOC entry 7405 (class 0 OID 2457281)
-- Dependencies: 380
-- Data for Name: isla_a; Type: TABLE DATA; Schema: ho_zonas_costeras; Owner: postgres
--



--
-- TOC entry 7407 (class 0 OID 2457293)
-- Dependencies: 382
-- Data for Name: orilla_l; Type: TABLE DATA; Schema: ho_zonas_costeras; Owner: postgres
--



--
-- TOC entry 7409 (class 0 OID 2457305)
-- Dependencies: 384
-- Data for Name: invernadero_a; Type: TABLE DATA; Schema: ii_agropecuaria; Owner: postgres
--



--
-- TOC entry 7411 (class 0 OID 2457318)
-- Dependencies: 386
-- Data for Name: acera_a; Type: TABLE DATA; Schema: it_asociado_transportacion; Owner: postgres
--



--
-- TOC entry 7413 (class 0 OID 2457330)
-- Dependencies: 388
-- Data for Name: bordillo_l; Type: TABLE DATA; Schema: it_asociado_transportacion; Owner: postgres
--



--
-- TOC entry 7415 (class 0 OID 2457342)
-- Dependencies: 390
-- Data for Name: cuneta_a; Type: TABLE DATA; Schema: it_asociado_transportacion; Owner: postgres
--



--
-- TOC entry 7417 (class 0 OID 2457354)
-- Dependencies: 392
-- Data for Name: parqueadero_a; Type: TABLE DATA; Schema: it_asociado_transportacion; Owner: postgres
--



--
-- TOC entry 7419 (class 0 OID 2457366)
-- Dependencies: 394
-- Data for Name: paseo_peatonal_ciclovia_a; Type: TABLE DATA; Schema: it_asociado_transportacion; Owner: postgres
--



--
-- TOC entry 7421 (class 0 OID 2457378)
-- Dependencies: 396
-- Data for Name: tunel_a; Type: TABLE DATA; Schema: it_asociado_transportacion; Owner: postgres
--



--
-- TOC entry 7423 (class 0 OID 2457390)
-- Dependencies: 398
-- Data for Name: puente_a; Type: TABLE DATA; Schema: it_cruces_enlaces; Owner: postgres
--



--
-- TOC entry 7425 (class 0 OID 2457402)
-- Dependencies: 400
-- Data for Name: ferrocarril_a; Type: TABLE DATA; Schema: it_ferrocarriles; Owner: postgres
--



--
-- TOC entry 7427 (class 0 OID 2457414)
-- Dependencies: 402
-- Data for Name: gasolinera_a; Type: TABLE DATA; Schema: it_transporte_terrestre; Owner: postgres
--



--
-- TOC entry 7429 (class 0 OID 2457426)
-- Dependencies: 404
-- Data for Name: intercambiador_vial_a; Type: TABLE DATA; Schema: it_transporte_terrestre; Owner: postgres
--



--
-- TOC entry 7431 (class 0 OID 2457438)
-- Dependencies: 406
-- Data for Name: rodera_l; Type: TABLE DATA; Schema: it_transporte_terrestre; Owner: postgres
--



--
-- TOC entry 7433 (class 0 OID 2457450)
-- Dependencies: 408
-- Data for Name: sendero_l; Type: TABLE DATA; Schema: it_transporte_terrestre; Owner: postgres
--



--
-- TOC entry 7435 (class 0 OID 2457462)
-- Dependencies: 410
-- Data for Name: via_ruta_a; Type: TABLE DATA; Schema: it_transporte_terrestre; Owner: postgres
--



--
-- TOC entry 7437 (class 0 OID 2457474)
-- Dependencies: 412
-- Data for Name: qgis_projects; Type: TABLE DATA; Schema: proyecto_qgis3; Owner: postgres
--

INSERT INTO proyecto_qgis3.qgis_projects VALUES ('CARTOGRAFIA BASE CATASTRAL', '{"last_modified_time": "2022-06-28 14:35:53.13126", "last_modified_user": "postgres"}', '\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');


--
-- TOC entry 6391 (class 0 OID 16696)
-- Dependencies: 237
-- Data for Name: spatial_ref_sys; Type: TABLE DATA; Schema: public; Owner: postgres
--

--
-- TOC entry 7526 (class 0 OID 0)
-- Dependencies: 310
-- Name: aeropuerto_a_gid_seq; Type: SEQUENCE SET; Schema: a_aeropuerto_superficie; Owner: postgres
--

SELECT pg_catalog.setval('a_aeropuerto_superficie.aeropuerto_a_gid_seq', 7, true);


--
-- TOC entry 7527 (class 0 OID 0)
-- Dependencies: 315
-- Name: catalogo_objetos_gid_seq; Type: SEQUENCE SET; Schema: catalogo_objetos; Owner: postgres
--

SELECT pg_catalog.setval('catalogo_objetos.catalogo_objetos_gid_seq', 200, true);


--
-- TOC entry 7528 (class 0 OID 0)
-- Dependencies: 341
-- Name: vertice_geodesico_p_gid_seq; Type: SEQUENCE SET; Schema: d_linderos_propiedad; Owner: postgres
--

SELECT pg_catalog.setval('d_linderos_propiedad.vertice_geodesico_p_gid_seq', 1, true);


--
-- TOC entry 7529 (class 0 OID 0)
-- Dependencies: 343
-- Name: cementerio_a_gid_seq; Type: SEQUENCE SET; Schema: gs_asociado_poblados; Owner: postgres
--

SELECT pg_catalog.setval('gs_asociado_poblados.cementerio_a_gid_seq', 1, false);


--
-- TOC entry 7530 (class 0 OID 0)
-- Dependencies: 345
-- Name: cerca_l_gid_seq; Type: SEQUENCE SET; Schema: gs_asociado_poblados; Owner: postgres
--

SELECT pg_catalog.setval('gs_asociado_poblados.cerca_l_gid_seq', 1, false);


--
-- TOC entry 7531 (class 0 OID 0)
-- Dependencies: 347
-- Name: escalinata_a_gid_seq; Type: SEQUENCE SET; Schema: gs_asociado_poblados; Owner: postgres
--

SELECT pg_catalog.setval('gs_asociado_poblados.escalinata_a_gid_seq', 1, false);


--
-- TOC entry 7532 (class 0 OID 0)
-- Dependencies: 349
-- Name: muro_l_gid_seq; Type: SEQUENCE SET; Schema: gs_asociado_poblados; Owner: postgres
--

SELECT pg_catalog.setval('gs_asociado_poblados.muro_l_gid_seq', 1, false);


--
-- TOC entry 7533 (class 0 OID 0)
-- Dependencies: 351
-- Name: plaza_publica_a_gid_seq; Type: SEQUENCE SET; Schema: gs_asociado_poblados; Owner: postgres
--

SELECT pg_catalog.setval('gs_asociado_poblados.plaza_publica_a_gid_seq', 1, false);


--
-- TOC entry 7534 (class 0 OID 0)
-- Dependencies: 353
-- Name: edificio_a_gid_seq; Type: SEQUENCE SET; Schema: gs_construcciones; Owner: postgres
--

SELECT pg_catalog.setval('gs_construcciones.edificio_a_gid_seq', 1, false);


--
-- TOC entry 7535 (class 0 OID 0)
-- Dependencies: 355
-- Name: cancha_a_gid_seq; Type: SEQUENCE SET; Schema: gs_recreacion; Owner: postgres
--

SELECT pg_catalog.setval('gs_recreacion.cancha_a_gid_seq', 1, false);


--
-- TOC entry 7536 (class 0 OID 0)
-- Dependencies: 357
-- Name: estadio_a_gid_seq; Type: SEQUENCE SET; Schema: gs_recreacion; Owner: postgres
--

SELECT pg_catalog.setval('gs_recreacion.estadio_a_gid_seq', 1, false);


--
-- TOC entry 7537 (class 0 OID 0)
-- Dependencies: 359
-- Name: parque_a_gid_seq; Type: SEQUENCE SET; Schema: gs_recreacion; Owner: postgres
--

SELECT pg_catalog.setval('gs_recreacion.parque_a_gid_seq', 1, false);


--
-- TOC entry 7538 (class 0 OID 0)
-- Dependencies: 361
-- Name: piscina_a_gid_seq; Type: SEQUENCE SET; Schema: gs_recreacion; Owner: postgres
--

SELECT pg_catalog.setval('gs_recreacion.piscina_a_gid_seq', 1, false);


--
-- TOC entry 7539 (class 0 OID 0)
-- Dependencies: 363
-- Name: plaza_toros_a_gid_seq; Type: SEQUENCE SET; Schema: gs_recreacion; Owner: postgres
--

SELECT pg_catalog.setval('gs_recreacion.plaza_toros_a_gid_seq', 1, false);


--
-- TOC entry 7540 (class 0 OID 0)
-- Dependencies: 365
-- Name: acequia_l_gid_seq; Type: SEQUENCE SET; Schema: ho_aguas_interiores; Owner: postgres
--

SELECT pg_catalog.setval('ho_aguas_interiores.acequia_l_gid_seq', 1, false);


--
-- TOC entry 7541 (class 0 OID 0)
-- Dependencies: 367
-- Name: acueducto_canal_a_gid_seq; Type: SEQUENCE SET; Schema: ho_aguas_interiores; Owner: postgres
--

SELECT pg_catalog.setval('ho_aguas_interiores.acueducto_canal_a_gid_seq', 1, false);


--
-- TOC entry 7542 (class 0 OID 0)
-- Dependencies: 369
-- Name: lago_laguna_a_gid_seq; Type: SEQUENCE SET; Schema: ho_aguas_interiores; Owner: postgres
--

SELECT pg_catalog.setval('ho_aguas_interiores.lago_laguna_a_gid_seq', 1, false);


--
-- TOC entry 7543 (class 0 OID 0)
-- Dependencies: 371
-- Name: rio_a_gid_seq; Type: SEQUENCE SET; Schema: ho_aguas_interiores; Owner: postgres
--

SELECT pg_catalog.setval('ho_aguas_interiores.rio_a_gid_seq', 1, false);


--
-- TOC entry 7544 (class 0 OID 0)
-- Dependencies: 373
-- Name: rio_l_gid_seq; Type: SEQUENCE SET; Schema: ho_aguas_interiores; Owner: postgres
--

SELECT pg_catalog.setval('ho_aguas_interiores.rio_l_gid_seq', 1, false);


--
-- TOC entry 7545 (class 0 OID 0)
-- Dependencies: 375
-- Name: zanja_l_gid_seq; Type: SEQUENCE SET; Schema: ho_aguas_interiores; Owner: postgres
--

SELECT pg_catalog.setval('ho_aguas_interiores.zanja_l_gid_seq', 1, false);


--
-- TOC entry 7546 (class 0 OID 0)
-- Dependencies: 377
-- Name: puerto_a_gid_seq; Type: SEQUENCE SET; Schema: ho_puertos_muelles; Owner: postgres
--

SELECT pg_catalog.setval('ho_puertos_muelles.puerto_a_gid_seq', 1, false);


--
-- TOC entry 7547 (class 0 OID 0)
-- Dependencies: 379
-- Name: granja_acuatica_a_gid_seq; Type: SEQUENCE SET; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--

SELECT pg_catalog.setval('ho_regulacion_zonas_restringidas.granja_acuatica_a_gid_seq', 1, false);


--
-- TOC entry 7548 (class 0 OID 0)
-- Dependencies: 381
-- Name: isla_a_gid_seq; Type: SEQUENCE SET; Schema: ho_zonas_costeras; Owner: postgres
--

SELECT pg_catalog.setval('ho_zonas_costeras.isla_a_gid_seq', 1, false);


--
-- TOC entry 7549 (class 0 OID 0)
-- Dependencies: 383
-- Name: orilla_l_gid_seq; Type: SEQUENCE SET; Schema: ho_zonas_costeras; Owner: postgres
--

SELECT pg_catalog.setval('ho_zonas_costeras.orilla_l_gid_seq', 1, false);


--
-- TOC entry 7550 (class 0 OID 0)
-- Dependencies: 385
-- Name: invernadero_a_gid_seq; Type: SEQUENCE SET; Schema: ii_agropecuaria; Owner: postgres
--

SELECT pg_catalog.setval('ii_agropecuaria.invernadero_a_gid_seq', 1, false);


--
-- TOC entry 7551 (class 0 OID 0)
-- Dependencies: 387
-- Name: acera_a_gid_seq; Type: SEQUENCE SET; Schema: it_asociado_transportacion; Owner: postgres
--

SELECT pg_catalog.setval('it_asociado_transportacion.acera_a_gid_seq', 1, false);


--
-- TOC entry 7552 (class 0 OID 0)
-- Dependencies: 389
-- Name: bordillo_l_gid_seq; Type: SEQUENCE SET; Schema: it_asociado_transportacion; Owner: postgres
--

SELECT pg_catalog.setval('it_asociado_transportacion.bordillo_l_gid_seq', 1, false);


--
-- TOC entry 7553 (class 0 OID 0)
-- Dependencies: 391
-- Name: cuneta_a_gid_seq; Type: SEQUENCE SET; Schema: it_asociado_transportacion; Owner: postgres
--

SELECT pg_catalog.setval('it_asociado_transportacion.cuneta_a_gid_seq', 1, false);


--
-- TOC entry 7554 (class 0 OID 0)
-- Dependencies: 393
-- Name: parqueadero_a_gid_seq; Type: SEQUENCE SET; Schema: it_asociado_transportacion; Owner: postgres
--

SELECT pg_catalog.setval('it_asociado_transportacion.parqueadero_a_gid_seq', 1, false);


--
-- TOC entry 7555 (class 0 OID 0)
-- Dependencies: 395
-- Name: paseo_peatonal_ciclovia_a_gid_seq; Type: SEQUENCE SET; Schema: it_asociado_transportacion; Owner: postgres
--

SELECT pg_catalog.setval('it_asociado_transportacion.paseo_peatonal_ciclovia_a_gid_seq', 1, false);


--
-- TOC entry 7556 (class 0 OID 0)
-- Dependencies: 397
-- Name: tunel_a_gid_seq; Type: SEQUENCE SET; Schema: it_asociado_transportacion; Owner: postgres
--

SELECT pg_catalog.setval('it_asociado_transportacion.tunel_a_gid_seq', 1, false);


--
-- TOC entry 7557 (class 0 OID 0)
-- Dependencies: 399
-- Name: puente_a_gid_seq; Type: SEQUENCE SET; Schema: it_cruces_enlaces; Owner: postgres
--

SELECT pg_catalog.setval('it_cruces_enlaces.puente_a_gid_seq', 1, false);


--
-- TOC entry 7558 (class 0 OID 0)
-- Dependencies: 401
-- Name: ferrocarril_a_gid_seq; Type: SEQUENCE SET; Schema: it_ferrocarriles; Owner: postgres
--

SELECT pg_catalog.setval('it_ferrocarriles.ferrocarril_a_gid_seq', 1, false);


--
-- TOC entry 7559 (class 0 OID 0)
-- Dependencies: 403
-- Name: gasolinera_a_gid_seq; Type: SEQUENCE SET; Schema: it_transporte_terrestre; Owner: postgres
--

SELECT pg_catalog.setval('it_transporte_terrestre.gasolinera_a_gid_seq', 1, false);


--
-- TOC entry 7560 (class 0 OID 0)
-- Dependencies: 405
-- Name: intercambiador_vial_a_gid_seq; Type: SEQUENCE SET; Schema: it_transporte_terrestre; Owner: postgres
--

SELECT pg_catalog.setval('it_transporte_terrestre.intercambiador_vial_a_gid_seq', 1, false);


--
-- TOC entry 7561 (class 0 OID 0)
-- Dependencies: 407
-- Name: rodera_l_gid_seq; Type: SEQUENCE SET; Schema: it_transporte_terrestre; Owner: postgres
--

SELECT pg_catalog.setval('it_transporte_terrestre.rodera_l_gid_seq', 14157, true);


--
-- TOC entry 7562 (class 0 OID 0)
-- Dependencies: 409
-- Name: sendero_l_gid_seq; Type: SEQUENCE SET; Schema: it_transporte_terrestre; Owner: postgres
--

SELECT pg_catalog.setval('it_transporte_terrestre.sendero_l_gid_seq', 1, false);


--
-- TOC entry 7563 (class 0 OID 0)
-- Dependencies: 411
-- Name: via_ruta_a_gid_seq; Type: SEQUENCE SET; Schema: it_transporte_terrestre; Owner: postgres
--

SELECT pg_catalog.setval('it_transporte_terrestre.via_ruta_a_gid_seq', 105, true);


--
-- TOC entry 6846 (class 2606 OID 2457695)
-- Name: aeropuerto_a aeropuerto_a_pkey; Type: CONSTRAINT; Schema: a_aeropuerto_superficie; Owner: postgres
--

ALTER TABLE ONLY a_aeropuerto_superficie.aeropuerto_a
    ADD CONSTRAINT aeropuerto_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6849 (class 2606 OID 2457697)
-- Name: acc acc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.acc
    ADD CONSTRAINT acc_pkey PRIMARY KEY (acc);


--
-- TOC entry 6851 (class 2606 OID 2457699)
-- Name: atc atc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.atc
    ADD CONSTRAINT atc_pkey PRIMARY KEY (atc);


--
-- TOC entry 6853 (class 2606 OID 2457701)
-- Name: bsc bsc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.bsc
    ADD CONSTRAINT bsc_pkey PRIMARY KEY (bsc);


--
-- TOC entry 6855 (class 2606 OID 2457703)
-- Name: catalogo_objetos catalogo_objetos_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.catalogo_objetos
    ADD CONSTRAINT catalogo_objetos_pkey PRIMARY KEY (fcode);


--
-- TOC entry 6857 (class 2606 OID 2457705)
-- Name: dit dit_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.dit
    ADD CONSTRAINT dit_pkey PRIMARY KEY (dit);


--
-- TOC entry 6859 (class 2606 OID 2457707)
-- Name: ela ela_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.ela
    ADD CONSTRAINT ela_pkey PRIMARY KEY (ela);


--
-- TOC entry 6861 (class 2606 OID 2457709)
-- Name: fco fco_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.fco
    ADD CONSTRAINT fco_pkey PRIMARY KEY (fco);


--
-- TOC entry 6863 (class 2606 OID 2457711)
-- Name: fti fti_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.fti
    ADD CONSTRAINT fti_pkey PRIMARY KEY (fti);


--
-- TOC entry 6865 (class 2606 OID 2457713)
-- Name: fuc fuc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.fuc
    ADD CONSTRAINT fuc_pkey PRIMARY KEY (fuc);


--
-- TOC entry 6867 (class 2606 OID 2457715)
-- Name: hct hct_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.hct
    ADD CONSTRAINT hct_pkey PRIMARY KEY (hct);


--
-- TOC entry 6869 (class 2606 OID 2457717)
-- Name: hyp hyp_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.hyp
    ADD CONSTRAINT hyp_pkey PRIMARY KEY (hyp);


--
-- TOC entry 6871 (class 2606 OID 2457719)
-- Name: kos kos_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.kos
    ADD CONSTRAINT kos_pkey PRIMARY KEY (kos);


--
-- TOC entry 6873 (class 2606 OID 2457721)
-- Name: loc loc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.loc
    ADD CONSTRAINT loc_pkey PRIMARY KEY (loc);


--
-- TOC entry 6875 (class 2606 OID 2457723)
-- Name: mes mes_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.mes
    ADD CONSTRAINT mes_pkey PRIMARY KEY (mes);


--
-- TOC entry 6877 (class 2606 OID 2457725)
-- Name: rdt rdt_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.rdt
    ADD CONSTRAINT rdt_pkey PRIMARY KEY (rdt);


--
-- TOC entry 6879 (class 2606 OID 2457727)
-- Name: rel rel_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.rel
    ADD CONSTRAINT rel_pkey PRIMARY KEY (rel);


--
-- TOC entry 6881 (class 2606 OID 2457729)
-- Name: rgc rgc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.rgc
    ADD CONSTRAINT rgc_pkey PRIMARY KEY (rgc);


--
-- TOC entry 6883 (class 2606 OID 2457731)
-- Name: rra rra_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.rra
    ADD CONSTRAINT rra_pkey PRIMARY KEY (rra);


--
-- TOC entry 6885 (class 2606 OID 2457733)
-- Name: rrc rrc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.rrc
    ADD CONSTRAINT rrc_pkey PRIMARY KEY (rrc);


--
-- TOC entry 6887 (class 2606 OID 2457735)
-- Name: rst rst_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.rst
    ADD CONSTRAINT rst_pkey PRIMARY KEY (rst);


--
-- TOC entry 6889 (class 2606 OID 2457737)
-- Name: slt slt_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.slt
    ADD CONSTRAINT slt_pkey PRIMARY KEY (slt);


--
-- TOC entry 6891 (class 2606 OID 2457739)
-- Name: smc smc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.smc
    ADD CONSTRAINT smc_pkey PRIMARY KEY (smc);


--
-- TOC entry 6893 (class 2606 OID 2457741)
-- Name: tra tra_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.tra
    ADD CONSTRAINT tra_pkey PRIMARY KEY (tra);


--
-- TOC entry 6895 (class 2606 OID 2457743)
-- Name: tuc tuc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.tuc
    ADD CONSTRAINT tuc_pkey PRIMARY KEY (tuc);


--
-- TOC entry 6897 (class 2606 OID 2457745)
-- Name: typ typ_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.typ
    ADD CONSTRAINT typ_pkey PRIMARY KEY (typ);


--
-- TOC entry 6899 (class 2606 OID 2457747)
-- Name: uuc uuc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.uuc
    ADD CONSTRAINT uuc_pkey PRIMARY KEY (uuc);


--
-- TOC entry 6901 (class 2606 OID 2457749)
-- Name: wtc wtc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.wtc
    ADD CONSTRAINT wtc_pkey PRIMARY KEY (wtc);


--
-- TOC entry 6903 (class 2606 OID 2457751)
-- Name: wti wti_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.wti
    ADD CONSTRAINT wti_pkey PRIMARY KEY (wti);


--
-- TOC entry 6905 (class 2606 OID 2457753)
-- Name: punto_control_p punto_control_p_pkey; Type: CONSTRAINT; Schema: d_linderos_propiedad; Owner: postgres
--

ALTER TABLE ONLY d_linderos_propiedad.punto_control_p
    ADD CONSTRAINT punto_control_p_pkey PRIMARY KEY (gid);


--
-- TOC entry 6908 (class 2606 OID 2457755)
-- Name: cementerio_a cementerio_a_pkey; Type: CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.cementerio_a
    ADD CONSTRAINT cementerio_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6911 (class 2606 OID 2457757)
-- Name: cerca_l cerca_l_pkey; Type: CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.cerca_l
    ADD CONSTRAINT cerca_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 6914 (class 2606 OID 2457759)
-- Name: escalinata_a escalinata_a_pkey; Type: CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.escalinata_a
    ADD CONSTRAINT escalinata_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6917 (class 2606 OID 2457761)
-- Name: muro_l muro_l_pkey; Type: CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.muro_l
    ADD CONSTRAINT muro_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 6920 (class 2606 OID 2457763)
-- Name: plaza_publica_a plaza_publica_a_pkey; Type: CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.plaza_publica_a
    ADD CONSTRAINT plaza_publica_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6923 (class 2606 OID 2457765)
-- Name: edificio_a edificio_a_pkey; Type: CONSTRAINT; Schema: gs_construcciones; Owner: postgres
--

ALTER TABLE ONLY gs_construcciones.edificio_a
    ADD CONSTRAINT edificio_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6926 (class 2606 OID 2457767)
-- Name: cancha_a cancha_a_pkey; Type: CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.cancha_a
    ADD CONSTRAINT cancha_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6929 (class 2606 OID 2457769)
-- Name: estadio_a estadio_a_pkey; Type: CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.estadio_a
    ADD CONSTRAINT estadio_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6932 (class 2606 OID 2457771)
-- Name: parque_a parque_a_pkey; Type: CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.parque_a
    ADD CONSTRAINT parque_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6935 (class 2606 OID 2457773)
-- Name: piscina_a piscina_a_pkey; Type: CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.piscina_a
    ADD CONSTRAINT piscina_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6938 (class 2606 OID 2457775)
-- Name: plaza_toros_a plaza_toros_a_pkey; Type: CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.plaza_toros_a
    ADD CONSTRAINT plaza_toros_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6941 (class 2606 OID 2457777)
-- Name: acequia_l acequia_l_pkey; Type: CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acequia_l
    ADD CONSTRAINT acequia_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 6944 (class 2606 OID 2457779)
-- Name: acueducto_canal_a acueducto_a_pkey; Type: CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acueducto_canal_a
    ADD CONSTRAINT acueducto_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6947 (class 2606 OID 2457781)
-- Name: lago_laguna_a lago_laguna_a_pkey; Type: CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.lago_laguna_a
    ADD CONSTRAINT lago_laguna_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6950 (class 2606 OID 2457783)
-- Name: rio_a rio_a_pkey; Type: CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.rio_a
    ADD CONSTRAINT rio_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6953 (class 2606 OID 2457785)
-- Name: rio_l rio_l_pkey; Type: CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.rio_l
    ADD CONSTRAINT rio_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 6957 (class 2606 OID 2457787)
-- Name: zanja_l zanja_l_pkey; Type: CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.zanja_l
    ADD CONSTRAINT zanja_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 6959 (class 2606 OID 2457789)
-- Name: puerto_a puerto_a_pkey; Type: CONSTRAINT; Schema: ho_puertos_muelles; Owner: postgres
--

ALTER TABLE ONLY ho_puertos_muelles.puerto_a
    ADD CONSTRAINT puerto_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6962 (class 2606 OID 2457791)
-- Name: granja_acuatica_a granja_acuatica_a_pkey; Type: CONSTRAINT; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--

ALTER TABLE ONLY ho_regulacion_zonas_restringidas.granja_acuatica_a
    ADD CONSTRAINT granja_acuatica_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6965 (class 2606 OID 2457793)
-- Name: isla_a isla_a_pkey; Type: CONSTRAINT; Schema: ho_zonas_costeras; Owner: postgres
--

ALTER TABLE ONLY ho_zonas_costeras.isla_a
    ADD CONSTRAINT isla_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6968 (class 2606 OID 2457795)
-- Name: orilla_l orilla_l_pkey; Type: CONSTRAINT; Schema: ho_zonas_costeras; Owner: postgres
--

ALTER TABLE ONLY ho_zonas_costeras.orilla_l
    ADD CONSTRAINT orilla_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 6971 (class 2606 OID 2457797)
-- Name: invernadero_a hacienda_a_pkey; Type: CONSTRAINT; Schema: ii_agropecuaria; Owner: postgres
--

ALTER TABLE ONLY ii_agropecuaria.invernadero_a
    ADD CONSTRAINT hacienda_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6974 (class 2606 OID 2457799)
-- Name: acera_a acera_a_pkey; Type: CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.acera_a
    ADD CONSTRAINT acera_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6977 (class 2606 OID 2457801)
-- Name: bordillo_l bordillo_l_pkey; Type: CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.bordillo_l
    ADD CONSTRAINT bordillo_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 6980 (class 2606 OID 2457803)
-- Name: cuneta_a cuneta_a_pkey; Type: CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.cuneta_a
    ADD CONSTRAINT cuneta_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6983 (class 2606 OID 2457805)
-- Name: parqueadero_a parqueadero_a_pkey; Type: CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.parqueadero_a
    ADD CONSTRAINT parqueadero_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6986 (class 2606 OID 2457807)
-- Name: paseo_peatonal_ciclovia_a paseo_peatonal_ciclovia_a_pkey; Type: CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.paseo_peatonal_ciclovia_a
    ADD CONSTRAINT paseo_peatonal_ciclovia_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6989 (class 2606 OID 2457809)
-- Name: tunel_a tunel_a_pkey; Type: CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.tunel_a
    ADD CONSTRAINT tunel_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6992 (class 2606 OID 2457811)
-- Name: puente_a puente_a_pkey; Type: CONSTRAINT; Schema: it_cruces_enlaces; Owner: postgres
--

ALTER TABLE ONLY it_cruces_enlaces.puente_a
    ADD CONSTRAINT puente_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6995 (class 2606 OID 2457813)
-- Name: ferrocarril_a ferrocarril_a_pkey; Type: CONSTRAINT; Schema: it_ferrocarriles; Owner: postgres
--

ALTER TABLE ONLY it_ferrocarriles.ferrocarril_a
    ADD CONSTRAINT ferrocarril_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6998 (class 2606 OID 2457815)
-- Name: gasolinera_a gasolinera_a_pkey; Type: CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.gasolinera_a
    ADD CONSTRAINT gasolinera_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7001 (class 2606 OID 2457817)
-- Name: intercambiador_vial_a intercambiador_vial_a_pkey; Type: CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.intercambiador_vial_a
    ADD CONSTRAINT intercambiador_vial_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7004 (class 2606 OID 2457819)
-- Name: rodera_l rodera_l_pkey; Type: CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.rodera_l
    ADD CONSTRAINT rodera_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 7007 (class 2606 OID 2457821)
-- Name: sendero_l sendero_l_pkey; Type: CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.sendero_l
    ADD CONSTRAINT sendero_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 7011 (class 2606 OID 2457823)
-- Name: via_ruta_a via_ruta_a_pkey; Type: CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a
    ADD CONSTRAINT via_ruta_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7013 (class 2606 OID 2457825)
-- Name: qgis_projects qgis_projects_pkey; Type: CONSTRAINT; Schema: proyecto_qgis3; Owner: postgres
--

ALTER TABLE ONLY proyecto_qgis3.qgis_projects
    ADD CONSTRAINT qgis_projects_pkey PRIMARY KEY (name);


--
-- TOC entry 6847 (class 1259 OID 2457826)
-- Name: sidx_aeropuerto_a; Type: INDEX; Schema: a_aeropuerto_superficie; Owner: postgres
--

CREATE INDEX sidx_aeropuerto_a ON a_aeropuerto_superficie.aeropuerto_a USING gist (the_geom);

ALTER TABLE a_aeropuerto_superficie.aeropuerto_a CLUSTER ON sidx_aeropuerto_a;


--
-- TOC entry 6906 (class 1259 OID 2457827)
-- Name: sidx_punto_control_p; Type: INDEX; Schema: d_linderos_propiedad; Owner: postgres
--

CREATE INDEX sidx_punto_control_p ON d_linderos_propiedad.punto_control_p USING gist (the_geom);


--
-- TOC entry 6909 (class 1259 OID 2457828)
-- Name: sidx_cementerio_a; Type: INDEX; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE INDEX sidx_cementerio_a ON gs_asociado_poblados.cementerio_a USING gist (the_geom);


--
-- TOC entry 6912 (class 1259 OID 2457829)
-- Name: sidx_cerca_l; Type: INDEX; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE INDEX sidx_cerca_l ON gs_asociado_poblados.cerca_l USING gist (the_geom);


--
-- TOC entry 6915 (class 1259 OID 2457830)
-- Name: sidx_escalinata_a; Type: INDEX; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE INDEX sidx_escalinata_a ON gs_asociado_poblados.escalinata_a USING gist (the_geom);


--
-- TOC entry 6918 (class 1259 OID 2457831)
-- Name: sidx_muro_l; Type: INDEX; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE INDEX sidx_muro_l ON gs_asociado_poblados.muro_l USING gist (the_geom);


--
-- TOC entry 6921 (class 1259 OID 2457832)
-- Name: sidx_plaza_publica_a; Type: INDEX; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE INDEX sidx_plaza_publica_a ON gs_asociado_poblados.plaza_publica_a USING gist (the_geom);


--
-- TOC entry 6924 (class 1259 OID 2457833)
-- Name: sidx_edificio_a; Type: INDEX; Schema: gs_construcciones; Owner: postgres
--

CREATE INDEX sidx_edificio_a ON gs_construcciones.edificio_a USING gist (the_geom);

ALTER TABLE gs_construcciones.edificio_a CLUSTER ON sidx_edificio_a;


--
-- TOC entry 6927 (class 1259 OID 2457834)
-- Name: sidx_cancha_a; Type: INDEX; Schema: gs_recreacion; Owner: postgres
--

CREATE INDEX sidx_cancha_a ON gs_recreacion.cancha_a USING gist (the_geom);


--
-- TOC entry 6930 (class 1259 OID 2457835)
-- Name: sidx_estadio_a; Type: INDEX; Schema: gs_recreacion; Owner: postgres
--

CREATE INDEX sidx_estadio_a ON gs_recreacion.estadio_a USING gist (the_geom);


--
-- TOC entry 6933 (class 1259 OID 2457836)
-- Name: sidx_parque_a; Type: INDEX; Schema: gs_recreacion; Owner: postgres
--

CREATE INDEX sidx_parque_a ON gs_recreacion.parque_a USING gist (the_geom);


--
-- TOC entry 6936 (class 1259 OID 2457837)
-- Name: sidx_piscina_a; Type: INDEX; Schema: gs_recreacion; Owner: postgres
--

CREATE INDEX sidx_piscina_a ON gs_recreacion.piscina_a USING gist (the_geom);


--
-- TOC entry 6939 (class 1259 OID 2457838)
-- Name: sidx_plaza_toros_a; Type: INDEX; Schema: gs_recreacion; Owner: postgres
--

CREATE INDEX sidx_plaza_toros_a ON gs_recreacion.plaza_toros_a USING gist (the_geom);


--
-- TOC entry 6942 (class 1259 OID 2457839)
-- Name: sidx_acequia_l; Type: INDEX; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE INDEX sidx_acequia_l ON ho_aguas_interiores.acequia_l USING gist (the_geom);


--
-- TOC entry 6945 (class 1259 OID 2457840)
-- Name: sidx_acueducto_a; Type: INDEX; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE INDEX sidx_acueducto_a ON ho_aguas_interiores.acueducto_canal_a USING gist (the_geom);


--
-- TOC entry 6948 (class 1259 OID 2457841)
-- Name: sidx_lago_laguna_a; Type: INDEX; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE INDEX sidx_lago_laguna_a ON ho_aguas_interiores.lago_laguna_a USING gist (the_geom);


--
-- TOC entry 6951 (class 1259 OID 2457842)
-- Name: sidx_rio_a; Type: INDEX; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE INDEX sidx_rio_a ON ho_aguas_interiores.rio_a USING gist (the_geom);


--
-- TOC entry 6954 (class 1259 OID 2457843)
-- Name: sidx_rio_l; Type: INDEX; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE INDEX sidx_rio_l ON ho_aguas_interiores.rio_l USING gist (the_geom);

ALTER TABLE ho_aguas_interiores.rio_l CLUSTER ON sidx_rio_l;


--
-- TOC entry 6955 (class 1259 OID 2457844)
-- Name: sidx_zanja_l; Type: INDEX; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE INDEX sidx_zanja_l ON ho_aguas_interiores.zanja_l USING gist (the_geom);


--
-- TOC entry 6960 (class 1259 OID 2457845)
-- Name: sidx_puerto_a; Type: INDEX; Schema: ho_puertos_muelles; Owner: postgres
--

CREATE INDEX sidx_puerto_a ON ho_puertos_muelles.puerto_a USING gist (the_geom);


--
-- TOC entry 6963 (class 1259 OID 2457846)
-- Name: sidx_granja_acuatica_a; Type: INDEX; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--

CREATE INDEX sidx_granja_acuatica_a ON ho_regulacion_zonas_restringidas.granja_acuatica_a USING gist (the_geom);


--
-- TOC entry 6966 (class 1259 OID 2457847)
-- Name: sidx_isla_a; Type: INDEX; Schema: ho_zonas_costeras; Owner: postgres
--

CREATE INDEX sidx_isla_a ON ho_zonas_costeras.isla_a USING gist (the_geom);


--
-- TOC entry 6969 (class 1259 OID 2457848)
-- Name: sidx_orilla_l; Type: INDEX; Schema: ho_zonas_costeras; Owner: postgres
--

CREATE INDEX sidx_orilla_l ON ho_zonas_costeras.orilla_l USING gist (the_geom);


--
-- TOC entry 6972 (class 1259 OID 2457849)
-- Name: sidx_hacienda_a; Type: INDEX; Schema: ii_agropecuaria; Owner: postgres
--

CREATE INDEX sidx_hacienda_a ON ii_agropecuaria.invernadero_a USING gist (the_geom);


--
-- TOC entry 6975 (class 1259 OID 2457850)
-- Name: acera_a_sidx_paseo_peatonal_ciclovia_a; Type: INDEX; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE INDEX acera_a_sidx_paseo_peatonal_ciclovia_a ON it_asociado_transportacion.acera_a USING gist (the_geom);


--
-- TOC entry 6978 (class 1259 OID 2457851)
-- Name: bordillo_l_sidx_bordillo_l; Type: INDEX; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE INDEX bordillo_l_sidx_bordillo_l ON it_asociado_transportacion.bordillo_l USING gist (the_geom);


--
-- TOC entry 6981 (class 1259 OID 2457852)
-- Name: cuneta_a_sidx_cuneta_a; Type: INDEX; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE INDEX cuneta_a_sidx_cuneta_a ON it_asociado_transportacion.cuneta_a USING gist (the_geom);


--
-- TOC entry 6984 (class 1259 OID 2457853)
-- Name: sidx_parqueadero_a; Type: INDEX; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE INDEX sidx_parqueadero_a ON it_asociado_transportacion.parqueadero_a USING gist (the_geom);


--
-- TOC entry 6987 (class 1259 OID 2457854)
-- Name: sidx_paseo_peatonal_ciclovia_a; Type: INDEX; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE INDEX sidx_paseo_peatonal_ciclovia_a ON it_asociado_transportacion.paseo_peatonal_ciclovia_a USING gist (the_geom);


--
-- TOC entry 6990 (class 1259 OID 2457855)
-- Name: tunel_a_sidx_tunel_a; Type: INDEX; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE INDEX tunel_a_sidx_tunel_a ON it_asociado_transportacion.tunel_a USING gist (the_geom);


--
-- TOC entry 6993 (class 1259 OID 2457856)
-- Name: sidx_puente_a; Type: INDEX; Schema: it_cruces_enlaces; Owner: postgres
--

CREATE INDEX sidx_puente_a ON it_cruces_enlaces.puente_a USING gist (the_geom);


--
-- TOC entry 6996 (class 1259 OID 2457857)
-- Name: ferrocarril_a_sidx_ferrocarril_a; Type: INDEX; Schema: it_ferrocarriles; Owner: postgres
--

CREATE INDEX ferrocarril_a_sidx_ferrocarril_a ON it_ferrocarriles.ferrocarril_a USING gist (the_geom);


--
-- TOC entry 6999 (class 1259 OID 2457858)
-- Name: sidx_gasolinera_a; Type: INDEX; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE INDEX sidx_gasolinera_a ON it_transporte_terrestre.gasolinera_a USING gist (the_geom);


--
-- TOC entry 7002 (class 1259 OID 2457859)
-- Name: sidx_intercambiador_vial_a; Type: INDEX; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE INDEX sidx_intercambiador_vial_a ON it_transporte_terrestre.intercambiador_vial_a USING gist (the_geom);


--
-- TOC entry 7005 (class 1259 OID 2457860)
-- Name: sidx_rodera_l; Type: INDEX; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE INDEX sidx_rodera_l ON it_transporte_terrestre.rodera_l USING gist (the_geom);


--
-- TOC entry 7008 (class 1259 OID 2457861)
-- Name: sidx_sendero_l; Type: INDEX; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE INDEX sidx_sendero_l ON it_transporte_terrestre.sendero_l USING gist (the_geom);


--
-- TOC entry 7009 (class 1259 OID 2457862)
-- Name: sidx_via_ruta_a; Type: INDEX; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE INDEX sidx_via_ruta_a ON it_transporte_terrestre.via_ruta_a USING gist (the_geom);


--
-- TOC entry 7297 (class 2618 OID 2457863)
-- Name: aeropuerto_a omitir_duplicados; Type: RULE; Schema: a_aeropuerto_superficie; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO a_aeropuerto_superficie.aeropuerto_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM a_aeropuerto_superficie.aeropuerto_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7298 (class 2618 OID 2457865)
-- Name: punto_control_p omitir_duplicados; Type: RULE; Schema: d_linderos_propiedad; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO d_linderos_propiedad.punto_control_p
   WHERE (0 <> ( SELECT count(*) AS count
           FROM d_linderos_propiedad.punto_control_p a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7299 (class 2618 OID 2457867)
-- Name: plaza_publica_a omitir_duplicados; Type: RULE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_asociado_poblados.plaza_publica_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_asociado_poblados.plaza_publica_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7300 (class 2618 OID 2457869)
-- Name: muro_l omitir_duplicados; Type: RULE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_asociado_poblados.muro_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_asociado_poblados.muro_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7301 (class 2618 OID 2457871)
-- Name: escalinata_a omitir_duplicados; Type: RULE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_asociado_poblados.escalinata_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_asociado_poblados.escalinata_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7302 (class 2618 OID 2457873)
-- Name: cerca_l omitir_duplicados; Type: RULE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_asociado_poblados.cerca_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_asociado_poblados.cerca_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7303 (class 2618 OID 2457875)
-- Name: cementerio_a omitir_duplicados; Type: RULE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_asociado_poblados.cementerio_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_asociado_poblados.cementerio_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7304 (class 2618 OID 2457877)
-- Name: edificio_a omitir_duplicados; Type: RULE; Schema: gs_construcciones; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_construcciones.edificio_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_construcciones.edificio_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7305 (class 2618 OID 2457879)
-- Name: plaza_toros_a omitir_duplicados; Type: RULE; Schema: gs_recreacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_recreacion.plaza_toros_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_recreacion.plaza_toros_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7306 (class 2618 OID 2457881)
-- Name: piscina_a omitir_duplicados; Type: RULE; Schema: gs_recreacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_recreacion.piscina_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_recreacion.piscina_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7307 (class 2618 OID 2457883)
-- Name: parque_a omitir_duplicados; Type: RULE; Schema: gs_recreacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_recreacion.parque_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_recreacion.parque_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7308 (class 2618 OID 2457885)
-- Name: estadio_a omitir_duplicados; Type: RULE; Schema: gs_recreacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_recreacion.estadio_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_recreacion.estadio_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7309 (class 2618 OID 2457887)
-- Name: cancha_a omitir_duplicados; Type: RULE; Schema: gs_recreacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_recreacion.cancha_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_recreacion.cancha_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7310 (class 2618 OID 2457889)
-- Name: zanja_l omitir_duplicados; Type: RULE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_aguas_interiores.zanja_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_aguas_interiores.zanja_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7311 (class 2618 OID 2457891)
-- Name: rio_l omitir_duplicados; Type: RULE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_aguas_interiores.rio_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_aguas_interiores.rio_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7312 (class 2618 OID 2457893)
-- Name: rio_a omitir_duplicados; Type: RULE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_aguas_interiores.rio_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_aguas_interiores.rio_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7313 (class 2618 OID 2457895)
-- Name: lago_laguna_a omitir_duplicados; Type: RULE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_aguas_interiores.lago_laguna_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_aguas_interiores.lago_laguna_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7314 (class 2618 OID 2457897)
-- Name: acueducto_canal_a omitir_duplicados; Type: RULE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_aguas_interiores.acueducto_canal_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_aguas_interiores.acueducto_canal_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7315 (class 2618 OID 2457899)
-- Name: acequia_l omitir_duplicados; Type: RULE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_aguas_interiores.acequia_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_aguas_interiores.acequia_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7316 (class 2618 OID 2457901)
-- Name: puerto_a omitir_duplicados; Type: RULE; Schema: ho_puertos_muelles; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_puertos_muelles.puerto_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_puertos_muelles.puerto_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7317 (class 2618 OID 2457903)
-- Name: granja_acuatica_a omitir_duplicados; Type: RULE; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_regulacion_zonas_restringidas.granja_acuatica_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_regulacion_zonas_restringidas.granja_acuatica_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7318 (class 2618 OID 2457905)
-- Name: orilla_l omitir_duplicados; Type: RULE; Schema: ho_zonas_costeras; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_zonas_costeras.orilla_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_zonas_costeras.orilla_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7319 (class 2618 OID 2457907)
-- Name: isla_a omitir_duplicados; Type: RULE; Schema: ho_zonas_costeras; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_zonas_costeras.isla_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_zonas_costeras.isla_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7320 (class 2618 OID 2457909)
-- Name: invernadero_a omitir_duplicados; Type: RULE; Schema: ii_agropecuaria; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ii_agropecuaria.invernadero_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ii_agropecuaria.invernadero_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7321 (class 2618 OID 2457911)
-- Name: paseo_peatonal_ciclovia_a omitir_duplicados; Type: RULE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_asociado_transportacion.paseo_peatonal_ciclovia_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_asociado_transportacion.paseo_peatonal_ciclovia_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7322 (class 2618 OID 2457913)
-- Name: parqueadero_a omitir_duplicados; Type: RULE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_asociado_transportacion.parqueadero_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_asociado_transportacion.parqueadero_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7323 (class 2618 OID 2457915)
-- Name: bordillo_l omitir_duplicados; Type: RULE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_asociado_transportacion.bordillo_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_asociado_transportacion.bordillo_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7324 (class 2618 OID 2457917)
-- Name: acera_a omitir_duplicados; Type: RULE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_asociado_transportacion.acera_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_asociado_transportacion.paseo_peatonal_ciclovia_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7325 (class 2618 OID 2457919)
-- Name: tunel_a omitir_duplicados; Type: RULE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_asociado_transportacion.tunel_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_asociado_transportacion.tunel_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7326 (class 2618 OID 2457921)
-- Name: cuneta_a omitir_duplicados; Type: RULE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_asociado_transportacion.cuneta_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_asociado_transportacion.cuneta_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7327 (class 2618 OID 2457923)
-- Name: puente_a omitir_duplicados; Type: RULE; Schema: it_cruces_enlaces; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_cruces_enlaces.puente_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_cruces_enlaces.puente_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7328 (class 2618 OID 2457925)
-- Name: ferrocarril_a omitir_duplicados; Type: RULE; Schema: it_ferrocarriles; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_ferrocarriles.ferrocarril_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_ferrocarriles.ferrocarril_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7329 (class 2618 OID 2457927)
-- Name: via_ruta_a omitir_duplicados; Type: RULE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_transporte_terrestre.via_ruta_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_transporte_terrestre.via_ruta_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7330 (class 2618 OID 2457929)
-- Name: sendero_l omitir_duplicados; Type: RULE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_transporte_terrestre.sendero_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_transporte_terrestre.sendero_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7331 (class 2618 OID 2457931)
-- Name: rodera_l omitir_duplicados; Type: RULE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_transporte_terrestre.rodera_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_transporte_terrestre.rodera_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7332 (class 2618 OID 2457933)
-- Name: intercambiador_vial_a omitir_duplicados; Type: RULE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_transporte_terrestre.intercambiador_vial_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_transporte_terrestre.intercambiador_vial_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7333 (class 2618 OID 2457935)
-- Name: gasolinera_a omitir_duplicados; Type: RULE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_transporte_terrestre.gasolinera_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_transporte_terrestre.gasolinera_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7014 (class 2606 OID 2457937)
-- Name: aeropuerto_a aeropuerto_a_fk; Type: FK CONSTRAINT; Schema: a_aeropuerto_superficie; Owner: postgres
--

ALTER TABLE ONLY a_aeropuerto_superficie.aeropuerto_a
    ADD CONSTRAINT aeropuerto_a_fk FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7015 (class 2606 OID 2457942)
-- Name: aeropuerto_a aeropuerto_a_fk1; Type: FK CONSTRAINT; Schema: a_aeropuerto_superficie; Owner: postgres
--

ALTER TABLE ONLY a_aeropuerto_superficie.aeropuerto_a
    ADD CONSTRAINT aeropuerto_a_fk1 FOREIGN KEY (fuc) REFERENCES catalogo_objetos.fuc(fuc);


--
-- TOC entry 7016 (class 2606 OID 2457947)
-- Name: aeropuerto_a aeropuerto_a_fk2; Type: FK CONSTRAINT; Schema: a_aeropuerto_superficie; Owner: postgres
--

ALTER TABLE ONLY a_aeropuerto_superficie.aeropuerto_a
    ADD CONSTRAINT aeropuerto_a_fk2 FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7017 (class 2606 OID 2457952)
-- Name: punto_control_p punto_control_p_fk; Type: FK CONSTRAINT; Schema: d_linderos_propiedad; Owner: postgres
--

ALTER TABLE ONLY d_linderos_propiedad.punto_control_p
    ADD CONSTRAINT punto_control_p_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7018 (class 2606 OID 2457957)
-- Name: punto_control_p punto_control_p_fk1; Type: FK CONSTRAINT; Schema: d_linderos_propiedad; Owner: postgres
--

ALTER TABLE ONLY d_linderos_propiedad.punto_control_p
    ADD CONSTRAINT punto_control_p_fk1 FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7019 (class 2606 OID 2457962)
-- Name: punto_control_p punto_control_p_fk2; Type: FK CONSTRAINT; Schema: d_linderos_propiedad; Owner: postgres
--

ALTER TABLE ONLY d_linderos_propiedad.punto_control_p
    ADD CONSTRAINT punto_control_p_fk2 FOREIGN KEY (ela) REFERENCES catalogo_objetos.ela(ela);


--
-- TOC entry 7020 (class 2606 OID 2457967)
-- Name: cementerio_a cementerio_a_fk; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.cementerio_a
    ADD CONSTRAINT cementerio_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7021 (class 2606 OID 2457972)
-- Name: cementerio_a cementerio_a_fk1; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.cementerio_a
    ADD CONSTRAINT cementerio_a_fk1 FOREIGN KEY (rel) REFERENCES catalogo_objetos.rel(rel);


--
-- TOC entry 7022 (class 2606 OID 2457977)
-- Name: cerca_l cerca_l_fk; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.cerca_l
    ADD CONSTRAINT cerca_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7023 (class 2606 OID 2457982)
-- Name: cerca_l cerca_l_fk1; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.cerca_l
    ADD CONSTRAINT cerca_l_fk1 FOREIGN KEY (fti) REFERENCES catalogo_objetos.fti(fti);


--
-- TOC entry 7024 (class 2606 OID 2457987)
-- Name: cerca_l cerca_l_fk2; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.cerca_l
    ADD CONSTRAINT cerca_l_fk2 FOREIGN KEY (wti) REFERENCES catalogo_objetos.wti(wti);


--
-- TOC entry 7025 (class 2606 OID 2457992)
-- Name: escalinata_a escalinata_a_fk; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.escalinata_a
    ADD CONSTRAINT escalinata_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7026 (class 2606 OID 2457997)
-- Name: escalinata_a escalinata_a_fk1; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.escalinata_a
    ADD CONSTRAINT escalinata_a_fk1 FOREIGN KEY (smc) REFERENCES catalogo_objetos.smc(smc);


--
-- TOC entry 7027 (class 2606 OID 2458002)
-- Name: muro_l muro_l_fk; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.muro_l
    ADD CONSTRAINT muro_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7028 (class 2606 OID 2458007)
-- Name: muro_l muro_l_fk1; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.muro_l
    ADD CONSTRAINT muro_l_fk1 FOREIGN KEY (wti) REFERENCES catalogo_objetos.wti(wti);


--
-- TOC entry 7029 (class 2606 OID 2458012)
-- Name: plaza_publica_a plaza_publica_a_fk; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.plaza_publica_a
    ADD CONSTRAINT plaza_publica_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7030 (class 2606 OID 2458017)
-- Name: plaza_publica_a plaza_publica_a_fk1; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.plaza_publica_a
    ADD CONSTRAINT plaza_publica_a_fk1 FOREIGN KEY (smc) REFERENCES catalogo_objetos.smc(smc);


--
-- TOC entry 7031 (class 2606 OID 2458022)
-- Name: edificio_a edificio_a_fk; Type: FK CONSTRAINT; Schema: gs_construcciones; Owner: postgres
--

ALTER TABLE ONLY gs_construcciones.edificio_a
    ADD CONSTRAINT edificio_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7032 (class 2606 OID 2458027)
-- Name: edificio_a edificio_a_fk1; Type: FK CONSTRAINT; Schema: gs_construcciones; Owner: postgres
--

ALTER TABLE ONLY gs_construcciones.edificio_a
    ADD CONSTRAINT edificio_a_fk1 FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7033 (class 2606 OID 2458032)
-- Name: edificio_a edificio_a_fk2; Type: FK CONSTRAINT; Schema: gs_construcciones; Owner: postgres
--

ALTER TABLE ONLY gs_construcciones.edificio_a
    ADD CONSTRAINT edificio_a_fk2 FOREIGN KEY (uuc) REFERENCES catalogo_objetos.uuc(uuc);


--
-- TOC entry 7034 (class 2606 OID 2458037)
-- Name: cancha_a cancha_a_fk; Type: FK CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.cancha_a
    ADD CONSTRAINT cancha_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7035 (class 2606 OID 2458042)
-- Name: cancha_a cancha_a_fk1; Type: FK CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.cancha_a
    ADD CONSTRAINT cancha_a_fk1 FOREIGN KEY (smc) REFERENCES catalogo_objetos.smc(smc);


--
-- TOC entry 7036 (class 2606 OID 2458047)
-- Name: cancha_a cancha_a_fk2; Type: FK CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.cancha_a
    ADD CONSTRAINT cancha_a_fk2 FOREIGN KEY (kos) REFERENCES catalogo_objetos.kos(kos);


--
-- TOC entry 7037 (class 2606 OID 2458052)
-- Name: estadio_a estadio_a_fk; Type: FK CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.estadio_a
    ADD CONSTRAINT estadio_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7038 (class 2606 OID 2458057)
-- Name: estadio_a estadio_a_fk1; Type: FK CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.estadio_a
    ADD CONSTRAINT estadio_a_fk1 FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7039 (class 2606 OID 2458062)
-- Name: parque_a parque_a_fk; Type: FK CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.parque_a
    ADD CONSTRAINT parque_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7040 (class 2606 OID 2458067)
-- Name: parque_a parque_a_fk1; Type: FK CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.parque_a
    ADD CONSTRAINT parque_a_fk1 FOREIGN KEY (fuc) REFERENCES catalogo_objetos.fuc(fuc);


--
-- TOC entry 7041 (class 2606 OID 2458072)
-- Name: piscina_a piscina_a_fk; Type: FK CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.piscina_a
    ADD CONSTRAINT piscina_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7042 (class 2606 OID 2458077)
-- Name: plaza_toros_a plaza_toros_a_fk; Type: FK CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.plaza_toros_a
    ADD CONSTRAINT plaza_toros_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7043 (class 2606 OID 2458082)
-- Name: acequia_l acequia_l_fk; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acequia_l
    ADD CONSTRAINT acequia_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7044 (class 2606 OID 2458087)
-- Name: acequia_l acequia_l_fk1; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acequia_l
    ADD CONSTRAINT acequia_l_fk1 FOREIGN KEY (hyp) REFERENCES catalogo_objetos.hyp(hyp);


--
-- TOC entry 7045 (class 2606 OID 2458092)
-- Name: acequia_l acequia_l_fk2; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acequia_l
    ADD CONSTRAINT acequia_l_fk2 FOREIGN KEY (dit) REFERENCES catalogo_objetos.dit(dit);


--
-- TOC entry 7046 (class 2606 OID 2458097)
-- Name: acueducto_canal_a acueducto_canal_a_fk; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acueducto_canal_a
    ADD CONSTRAINT acueducto_canal_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7047 (class 2606 OID 2458102)
-- Name: acueducto_canal_a acueducto_canal_a_fk1; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acueducto_canal_a
    ADD CONSTRAINT acueducto_canal_a_fk1 FOREIGN KEY (atc) REFERENCES catalogo_objetos.atc(atc);


--
-- TOC entry 7048 (class 2606 OID 2458107)
-- Name: acueducto_canal_a acueducto_canal_a_fk2; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acueducto_canal_a
    ADD CONSTRAINT acueducto_canal_a_fk2 FOREIGN KEY (smc) REFERENCES catalogo_objetos.smc(smc);


--
-- TOC entry 7049 (class 2606 OID 2458112)
-- Name: lago_laguna_a lago_laguna_a_fk; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.lago_laguna_a
    ADD CONSTRAINT lago_laguna_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7050 (class 2606 OID 2458117)
-- Name: lago_laguna_a lago_laguna_a_fk1; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.lago_laguna_a
    ADD CONSTRAINT lago_laguna_a_fk1 FOREIGN KEY (hyp) REFERENCES catalogo_objetos.hyp(hyp);


--
-- TOC entry 7051 (class 2606 OID 2458122)
-- Name: rio_a rio_a_fk; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.rio_a
    ADD CONSTRAINT rio_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7052 (class 2606 OID 2458127)
-- Name: rio_a rio_a_fk1; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.rio_a
    ADD CONSTRAINT rio_a_fk1 FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7053 (class 2606 OID 2458132)
-- Name: rio_a rio_a_fk2; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.rio_a
    ADD CONSTRAINT rio_a_fk2 FOREIGN KEY (hyp) REFERENCES catalogo_objetos.hyp(hyp);


--
-- TOC entry 7054 (class 2606 OID 2458137)
-- Name: rio_l rio_l_fk; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.rio_l
    ADD CONSTRAINT rio_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7055 (class 2606 OID 2458142)
-- Name: rio_l rio_l_fk1; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.rio_l
    ADD CONSTRAINT rio_l_fk1 FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7056 (class 2606 OID 2458147)
-- Name: rio_l rio_l_fk2; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.rio_l
    ADD CONSTRAINT rio_l_fk2 FOREIGN KEY (hyp) REFERENCES catalogo_objetos.hyp(hyp);


--
-- TOC entry 7057 (class 2606 OID 2458152)
-- Name: zanja_l zanja_l_fk; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.zanja_l
    ADD CONSTRAINT zanja_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7058 (class 2606 OID 2458157)
-- Name: zanja_l zanja_l_fk1; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.zanja_l
    ADD CONSTRAINT zanja_l_fk1 FOREIGN KEY (hyp) REFERENCES catalogo_objetos.hyp(hyp);


--
-- TOC entry 7059 (class 2606 OID 2458162)
-- Name: puerto_a puerto_a_fk; Type: FK CONSTRAINT; Schema: ho_puertos_muelles; Owner: postgres
--

ALTER TABLE ONLY ho_puertos_muelles.puerto_a
    ADD CONSTRAINT puerto_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7060 (class 2606 OID 2458167)
-- Name: granja_acuatica_a granja_acuatica_a_fk; Type: FK CONSTRAINT; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--

ALTER TABLE ONLY ho_regulacion_zonas_restringidas.granja_acuatica_a
    ADD CONSTRAINT granja_acuatica_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7061 (class 2606 OID 2458172)
-- Name: isla_a isla_a_fk; Type: FK CONSTRAINT; Schema: ho_zonas_costeras; Owner: postgres
--

ALTER TABLE ONLY ho_zonas_costeras.isla_a
    ADD CONSTRAINT isla_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7062 (class 2606 OID 2458177)
-- Name: orilla_l orilla_l_fk; Type: FK CONSTRAINT; Schema: ho_zonas_costeras; Owner: postgres
--

ALTER TABLE ONLY ho_zonas_costeras.orilla_l
    ADD CONSTRAINT orilla_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7063 (class 2606 OID 2458182)
-- Name: orilla_l orilla_l_fk1; Type: FK CONSTRAINT; Schema: ho_zonas_costeras; Owner: postgres
--

ALTER TABLE ONLY ho_zonas_costeras.orilla_l
    ADD CONSTRAINT orilla_l_fk1 FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7064 (class 2606 OID 2458187)
-- Name: orilla_l orilla_l_fk2; Type: FK CONSTRAINT; Schema: ho_zonas_costeras; Owner: postgres
--

ALTER TABLE ONLY ho_zonas_costeras.orilla_l
    ADD CONSTRAINT orilla_l_fk2 FOREIGN KEY (slt) REFERENCES catalogo_objetos.slt(slt);


--
-- TOC entry 7065 (class 2606 OID 2458192)
-- Name: invernadero_a invernadero_a_fk; Type: FK CONSTRAINT; Schema: ii_agropecuaria; Owner: postgres
--

ALTER TABLE ONLY ii_agropecuaria.invernadero_a
    ADD CONSTRAINT invernadero_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7066 (class 2606 OID 2458197)
-- Name: acera_a acera_a_fk; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.acera_a
    ADD CONSTRAINT acera_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7067 (class 2606 OID 2458202)
-- Name: acera_a acera_a_fk1; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.acera_a
    ADD CONSTRAINT acera_a_fk1 FOREIGN KEY (smc) REFERENCES catalogo_objetos.smc(smc);


--
-- TOC entry 7068 (class 2606 OID 2458207)
-- Name: bordillo_l bordillo_l_fk; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.bordillo_l
    ADD CONSTRAINT bordillo_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7069 (class 2606 OID 2458212)
-- Name: bordillo_l bordillo_l_fk1; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.bordillo_l
    ADD CONSTRAINT bordillo_l_fk1 FOREIGN KEY (smc) REFERENCES catalogo_objetos.smc(smc);


--
-- TOC entry 7070 (class 2606 OID 2458217)
-- Name: cuneta_a cuneta_a_fk; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.cuneta_a
    ADD CONSTRAINT cuneta_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7071 (class 2606 OID 2458222)
-- Name: cuneta_a cuneta_a_fk1; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.cuneta_a
    ADD CONSTRAINT cuneta_a_fk1 FOREIGN KEY (smc) REFERENCES catalogo_objetos.smc(smc);


--
-- TOC entry 7072 (class 2606 OID 2458227)
-- Name: parqueadero_a parqueadero_a_fk; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.parqueadero_a
    ADD CONSTRAINT parqueadero_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7073 (class 2606 OID 2458232)
-- Name: parqueadero_a parqueadero_a_fk1; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.parqueadero_a
    ADD CONSTRAINT parqueadero_a_fk1 FOREIGN KEY (smc) REFERENCES catalogo_objetos.smc(smc);


--
-- TOC entry 7074 (class 2606 OID 2458237)
-- Name: paseo_peatonal_ciclovia_a paseo_peatonal_ciclovia_a_fk; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.paseo_peatonal_ciclovia_a
    ADD CONSTRAINT paseo_peatonal_ciclovia_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7075 (class 2606 OID 2458242)
-- Name: paseo_peatonal_ciclovia_a paseo_peatonal_ciclovia_a_fk1; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.paseo_peatonal_ciclovia_a
    ADD CONSTRAINT paseo_peatonal_ciclovia_a_fk1 FOREIGN KEY (smc) REFERENCES catalogo_objetos.smc(smc);


--
-- TOC entry 7076 (class 2606 OID 2458247)
-- Name: tunel_a tunel_a_fk; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.tunel_a
    ADD CONSTRAINT tunel_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7077 (class 2606 OID 2458252)
-- Name: tunel_a tunel_a_fk1; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.tunel_a
    ADD CONSTRAINT tunel_a_fk1 FOREIGN KEY (tra) REFERENCES catalogo_objetos.tra(tra);


--
-- TOC entry 7078 (class 2606 OID 2458257)
-- Name: tunel_a tunel_a_fk2; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.tunel_a
    ADD CONSTRAINT tunel_a_fk2 FOREIGN KEY (tuc) REFERENCES catalogo_objetos.tuc(tuc);


--
-- TOC entry 7079 (class 2606 OID 2458262)
-- Name: puente_a puente_a_fk; Type: FK CONSTRAINT; Schema: it_cruces_enlaces; Owner: postgres
--

ALTER TABLE ONLY it_cruces_enlaces.puente_a
    ADD CONSTRAINT puente_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7080 (class 2606 OID 2458267)
-- Name: puente_a puente_a_fk1; Type: FK CONSTRAINT; Schema: it_cruces_enlaces; Owner: postgres
--

ALTER TABLE ONLY it_cruces_enlaces.puente_a
    ADD CONSTRAINT puente_a_fk1 FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7081 (class 2606 OID 2458272)
-- Name: puente_a puente_a_fk2; Type: FK CONSTRAINT; Schema: it_cruces_enlaces; Owner: postgres
--

ALTER TABLE ONLY it_cruces_enlaces.puente_a
    ADD CONSTRAINT puente_a_fk2 FOREIGN KEY (bsc) REFERENCES catalogo_objetos.bsc(bsc);


--
-- TOC entry 7082 (class 2606 OID 2458277)
-- Name: puente_a puente_a_fk3; Type: FK CONSTRAINT; Schema: it_cruces_enlaces; Owner: postgres
--

ALTER TABLE ONLY it_cruces_enlaces.puente_a
    ADD CONSTRAINT puente_a_fk3 FOREIGN KEY (typ) REFERENCES catalogo_objetos.typ(typ);


--
-- TOC entry 7083 (class 2606 OID 2458282)
-- Name: puente_a puente_a_fk4; Type: FK CONSTRAINT; Schema: it_cruces_enlaces; Owner: postgres
--

ALTER TABLE ONLY it_cruces_enlaces.puente_a
    ADD CONSTRAINT puente_a_fk4 FOREIGN KEY (tuc) REFERENCES catalogo_objetos.tuc(tuc);


--
-- TOC entry 7084 (class 2606 OID 2458287)
-- Name: ferrocarril_a ferrocarril_a_fk; Type: FK CONSTRAINT; Schema: it_ferrocarriles; Owner: postgres
--

ALTER TABLE ONLY it_ferrocarriles.ferrocarril_a
    ADD CONSTRAINT ferrocarril_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7085 (class 2606 OID 2458292)
-- Name: ferrocarril_a ferrocarril_a_fk1; Type: FK CONSTRAINT; Schema: it_ferrocarriles; Owner: postgres
--

ALTER TABLE ONLY it_ferrocarriles.ferrocarril_a
    ADD CONSTRAINT ferrocarril_a_fk1 FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7086 (class 2606 OID 2458297)
-- Name: ferrocarril_a ferrocarril_a_fk2; Type: FK CONSTRAINT; Schema: it_ferrocarriles; Owner: postgres
--

ALTER TABLE ONLY it_ferrocarriles.ferrocarril_a
    ADD CONSTRAINT ferrocarril_a_fk2 FOREIGN KEY (fco) REFERENCES catalogo_objetos.fco(fco);


--
-- TOC entry 7087 (class 2606 OID 2458302)
-- Name: ferrocarril_a ferrocarril_a_fk3; Type: FK CONSTRAINT; Schema: it_ferrocarriles; Owner: postgres
--

ALTER TABLE ONLY it_ferrocarriles.ferrocarril_a
    ADD CONSTRAINT ferrocarril_a_fk3 FOREIGN KEY (loc) REFERENCES catalogo_objetos.loc(loc);


--
-- TOC entry 7088 (class 2606 OID 2458307)
-- Name: ferrocarril_a ferrocarril_a_fk4; Type: FK CONSTRAINT; Schema: it_ferrocarriles; Owner: postgres
--

ALTER TABLE ONLY it_ferrocarriles.ferrocarril_a
    ADD CONSTRAINT ferrocarril_a_fk4 FOREIGN KEY (rgc) REFERENCES catalogo_objetos.rgc(rgc);


--
-- TOC entry 7089 (class 2606 OID 2458312)
-- Name: ferrocarril_a ferrocarril_a_fk5; Type: FK CONSTRAINT; Schema: it_ferrocarriles; Owner: postgres
--

ALTER TABLE ONLY it_ferrocarriles.ferrocarril_a
    ADD CONSTRAINT ferrocarril_a_fk5 FOREIGN KEY (rra) REFERENCES catalogo_objetos.rra(rra);


--
-- TOC entry 7090 (class 2606 OID 2458317)
-- Name: ferrocarril_a ferrocarril_a_fk6; Type: FK CONSTRAINT; Schema: it_ferrocarriles; Owner: postgres
--

ALTER TABLE ONLY it_ferrocarriles.ferrocarril_a
    ADD CONSTRAINT ferrocarril_a_fk6 FOREIGN KEY (rrc) REFERENCES catalogo_objetos.rrc(rrc);


--
-- TOC entry 7091 (class 2606 OID 2458322)
-- Name: gasolinera_a gasolinera_a_fk; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.gasolinera_a
    ADD CONSTRAINT gasolinera_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7092 (class 2606 OID 2458327)
-- Name: intercambiador_vial_a intercambiador_vial_a_fk; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.intercambiador_vial_a
    ADD CONSTRAINT intercambiador_vial_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7093 (class 2606 OID 2458332)
-- Name: intercambiador_vial_a intercambiador_vial_a_fk1; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.intercambiador_vial_a
    ADD CONSTRAINT intercambiador_vial_a_fk1 FOREIGN KEY (hct) REFERENCES catalogo_objetos.hct(hct);


--
-- TOC entry 7094 (class 2606 OID 2458337)
-- Name: intercambiador_vial_a intercambiador_vial_a_fk2; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.intercambiador_vial_a
    ADD CONSTRAINT intercambiador_vial_a_fk2 FOREIGN KEY (rst) REFERENCES catalogo_objetos.rst(rst);


--
-- TOC entry 7095 (class 2606 OID 2458342)
-- Name: intercambiador_vial_a intercambiador_vial_a_fk3; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.intercambiador_vial_a
    ADD CONSTRAINT intercambiador_vial_a_fk3 FOREIGN KEY (loc) REFERENCES catalogo_objetos.loc(loc);


--
-- TOC entry 7096 (class 2606 OID 2458347)
-- Name: rodera_l rodera_l_fk; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.rodera_l
    ADD CONSTRAINT rodera_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7097 (class 2606 OID 2458352)
-- Name: rodera_l rodera_l_fk1; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.rodera_l
    ADD CONSTRAINT rodera_l_fk1 FOREIGN KEY (typ) REFERENCES catalogo_objetos.typ(typ);


--
-- TOC entry 7098 (class 2606 OID 2458357)
-- Name: rodera_l rodera_l_fk2; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.rodera_l
    ADD CONSTRAINT rodera_l_fk2 FOREIGN KEY (rst) REFERENCES catalogo_objetos.rst(rst);


--
-- TOC entry 7099 (class 2606 OID 2458362)
-- Name: rodera_l rodera_l_fk3; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.rodera_l
    ADD CONSTRAINT rodera_l_fk3 FOREIGN KEY (hct) REFERENCES catalogo_objetos.hct(hct);


--
-- TOC entry 7100 (class 2606 OID 2458367)
-- Name: rodera_l rodera_l_fk4; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.rodera_l
    ADD CONSTRAINT rodera_l_fk4 FOREIGN KEY (rdt) REFERENCES catalogo_objetos.rdt(rdt);


--
-- TOC entry 7101 (class 2606 OID 2458372)
-- Name: rodera_l rodera_l_fk5; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.rodera_l
    ADD CONSTRAINT rodera_l_fk5 FOREIGN KEY (wtc) REFERENCES catalogo_objetos.wtc(wtc);


--
-- TOC entry 7102 (class 2606 OID 2458377)
-- Name: rodera_l rodera_l_fk6; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.rodera_l
    ADD CONSTRAINT rodera_l_fk6 FOREIGN KEY (tuc) REFERENCES catalogo_objetos.tuc(tuc);


--
-- TOC entry 7103 (class 2606 OID 2458382)
-- Name: sendero_l sendero_l_fk; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.sendero_l
    ADD CONSTRAINT sendero_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7104 (class 2606 OID 2458387)
-- Name: sendero_l sendero_l_fk1; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.sendero_l
    ADD CONSTRAINT sendero_l_fk1 FOREIGN KEY (wtc) REFERENCES catalogo_objetos.wtc(wtc);


--
-- TOC entry 7105 (class 2606 OID 2458392)
-- Name: via_ruta_a via_ruta_a_fk; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a
    ADD CONSTRAINT via_ruta_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7106 (class 2606 OID 2458397)
-- Name: via_ruta_a via_ruta_a_fk1; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a
    ADD CONSTRAINT via_ruta_a_fk1 FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7107 (class 2606 OID 2458402)
-- Name: via_ruta_a via_ruta_a_fk2; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a
    ADD CONSTRAINT via_ruta_a_fk2 FOREIGN KEY (rst) REFERENCES catalogo_objetos.rst(rst);


--
-- TOC entry 7108 (class 2606 OID 2458407)
-- Name: via_ruta_a via_ruta_a_fk3; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a
    ADD CONSTRAINT via_ruta_a_fk3 FOREIGN KEY (typ) REFERENCES catalogo_objetos.typ(typ);


--
-- TOC entry 7109 (class 2606 OID 2458412)
-- Name: via_ruta_a via_ruta_a_fk4; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a
    ADD CONSTRAINT via_ruta_a_fk4 FOREIGN KEY (hct) REFERENCES catalogo_objetos.hct(hct);


--
-- TOC entry 7110 (class 2606 OID 2458417)
-- Name: via_ruta_a via_ruta_a_fk5; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a
    ADD CONSTRAINT via_ruta_a_fk5 FOREIGN KEY (loc) REFERENCES catalogo_objetos.loc(loc);


--
-- TOC entry 7111 (class 2606 OID 2458422)
-- Name: via_ruta_a via_ruta_a_fk6; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a
    ADD CONSTRAINT via_ruta_a_fk6 FOREIGN KEY (mes) REFERENCES catalogo_objetos.mes(mes);


--
-- TOC entry 7112 (class 2606 OID 2458427)
-- Name: via_ruta_a via_ruta_a_fk7; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a
    ADD CONSTRAINT via_ruta_a_fk7 FOREIGN KEY (rdt) REFERENCES catalogo_objetos.rdt(rdt);


--
-- TOC entry 7113 (class 2606 OID 2458432)
-- Name: via_ruta_a via_ruta_a_fk8; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a
    ADD CONSTRAINT via_ruta_a_fk8 FOREIGN KEY (tuc) REFERENCES catalogo_objetos.tuc(tuc);


-- Completed on 2022-08-25 15:08:04

--
-- PostgreSQL database dump complete
--

